<?php
/**
 * products_collection Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

if ( !class_exists('WooCommerce') ) {
    return;
}

// Add products_collection section
$wp_customize->add_section( 'teach_kiddo_pro_products_collection_section', array(
	'title'             => esc_html__( 'Products Collection','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
        	teach_kiddo_pro_is_all_layout( $control )
        	||
        	teach_kiddo_pro_is_third_layout( $control )
        );
    },
) );

// products_collection content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[products_collection_section_enable]', array(
	'default'			=> 	$options['products_collection_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[products_collection_section_enable]', array(
	'label'             => esc_html__( 'Products Collection Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_products_collection_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[products_collection_section_enable]', array(
		'selector'            => '#products-collection .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[products_collection_section_enable]',
    ) );
}

// blog title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[products_collection_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['products_collection_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[products_collection_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_products_collection_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_products_collection_section_enable',
	'type'				=> 'text',
	) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[products_collection_title]', array(
		'selector'            => '#products-collection .section-header h2',
		'settings'            => 'teach_kiddo_pro_theme_options[products_collection_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_products_collection_title_partial',
		) );
}

// blog title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[products_collection_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['products_collection_btn_label'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[products_collection_btn_label]', array(
	'label'           	=> esc_html__( 'Btn Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_products_collection_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_products_collection_section_enable',
	'type'				=> 'text',
	) );

for ( $i = 1; $i <= 4; $i++ ) :

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[products_collection_content_products_collection_category_'.$i.']', array(
	'sanitize_callback' => 'absint',
	) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[products_collection_content_products_collection_category_'.$i.']', array(
	'label'             => sprintf( esc_html__( 'Select Featured Products Category %d', 'teach-kiddo-pro' ), $i ),
	'section'           => 'teach_kiddo_pro_products_collection_section',
	'taxonomy'			=> 'product_cat',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_products_collection_section_enable'
	) ) );

// products_collection title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[products_collection_sub_title_'.$i.']', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[products_collection_sub_title_'.$i.']', array(
	'label'             => sprintf( esc_html__( 'Product Category Label %d', 'teach-kiddo-pro' ), $i ),
	'section'        	=> 'teach_kiddo_pro_products_collection_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_products_collection_section_enable',
	'type'				=> 'text',
) );

endfor;