<?php
/**
 * Promotion Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Promotion section
$wp_customize->add_section( 'teach_kiddo_pro_promotion_section', array(
    'title'             => esc_html__( 'Promotion','teach-kiddo-pro' ),
    'description'       => esc_html__( 'Promotion Section options.', 'teach-kiddo-pro' ),
    'panel'             => 'teach_kiddo_pro_front_page_panel',
    'active_callback'   => function( $control ) {
        return ( 
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
            ||
            teach_kiddo_pro_is_third_layout( $control )
            ||
            teach_kiddo_pro_is_fourth_layout( $control )

        );
    },
) );

// Promotion content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_section_enable]', array(
    'default'           =>  $options['promotion_section_enable'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[promotion_section_enable]', array(
    'label'             => esc_html__( 'Promotion Section Enable', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'on_off_label'      => teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[promotion_section_enable]', array(
        'selector'            => '#promotion-section .tooltiptext',
        'settings'            => 'teach_kiddo_pro_theme_options[promotion_section_enable]',
    ) );
}

// promotion number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_image]', array(
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[promotion_image]', array(
    'label'             => esc_html__( 'Background Image', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_enable',
) ) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_excerpt_length]', array(
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
    'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
    'default'           => $options['promotion_excerpt_length'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_excerpt_length]', array(
    'label'             => esc_html__( 'Promotion Excerpt Length', 'teach-kiddo-pro' ),
    'description'       => esc_html__( 'Total description words to be displayed in promotion posts.', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'style'       => 'width: 80px;',
        'max'         => 100,
        'min'         => 5,
    ),
) );

// Promotion content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_content_type]', array(
    'default'           => $options['promotion_content_type'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'type'              => 'select',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_enable',
    'choices'           => array( 
        'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
        'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
        'custom'    => esc_html__( 'Custom', 'teach-kiddo-pro' ),
    ),
) );

// promotion pages drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_content_page]', array(
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[promotion_content_page]', array(
    'label'             => esc_html__( 'Select Page', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'choices'           => teach_kiddo_pro_page_choices(),
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_content_page_enable',
) ) );

// promotion posts drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_content_post]', array(
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[promotion_content_post]', array(
    'label'             => esc_html__( 'Select Post', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'choices'           => teach_kiddo_pro_post_choices(),
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_content_post_enable',
) ) );

// promotion title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_title]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['promotion_title'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_title]', array(
    'label'             => esc_html__( 'Title', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_content_custom_enable',
    'type'              => 'text',
) );

// promotion description setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_description]', array(
    'sanitize_callback' => 'wp_kses_post',
    'default'           => $options['promotion_description'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_description]', array(
    'label'             => esc_html__( 'Description', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_content_custom_enable',
    'type'              => 'textarea',
) );

// promotion title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_button]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['promotion_button'],
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_button]', array(
    'label'             => esc_html__( 'Promotion Button', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_enable',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[promotion_button]', array(
        'selector'            => '#promotion-section .read-more a',
        'settings'            => 'teach_kiddo_pro_theme_options[promotion_button]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'teach_kiddo_pro_promotion_button_partial',
    ) );
}

// promotion btn link setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[promotion_button_link]', array(
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[promotion_button_link]', array(
    'label'             => esc_html__( 'Button Link', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_promotion_section',
    'active_callback'   => 'teach_kiddo_pro_is_promotion_section_content_custom_enable',
    'type'              => 'url',
) );