<?php
/**
 * Recent Products Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( !class_exists('WooCommerce') ) {
    return;
}

// Add recent_products section
$wp_customize->add_section( 'teach_kiddo_pro_recent_products_section', array(
    'title'             => esc_html__( 'Recent Products','teach-kiddo-pro' ),
    'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'teach-kiddo-pro' ),
    'panel'             => 'teach_kiddo_pro_front_page_panel',
    'active_callback'   => function( $control ) {
        return ( 
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_third_layout( $control )
            );
    },
) );

// recent_products content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[recent_products_section_enable]', array(
    'default'           =>  $options['recent_products_section_enable'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[recent_products_section_enable]', array(
    'label'             => esc_html__( 'Recent product Section Enable', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_recent_products_section',
    'on_off_label'      => teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[recent_products_section_enable]', array(
        'selector'            => '#recent-products .tooltiptext',
        'settings'            => 'teach_kiddo_pro_theme_options[recent_products_section_enable]',
    ) );
}


// recent_products title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[recent_products_title]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['recent_products_title'],
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[recent_products_title]', array(
    'label'             => esc_html__( 'Title', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_recent_products_section',
    'active_callback'   => 'teach_kiddo_pro_is_recent_products_section_enable',
    'type'              => 'text',
) );
// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[recent_products_title]', array(
        'selector'            => '#recent-products h2.section-title',
        'settings'            => 'teach_kiddo_pro_theme_options[recent_products_title]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'teach_kiddo_pro_recent_products_title_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[recent_products_count]', array(
    'default'           => $options['recent_products_count'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
    'validate_callback' => 'teach_kiddo_pro_validate_recent_products_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[recent_products_count]', array(
    'label'             => esc_html__( 'Number of Products', 'teach-kiddo-pro' ),
    'description'       => esc_html__( 'Note: Min 1 & Max 30. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_recent_products_section',
    'active_callback'   => 'teach_kiddo_pro_is_recent_products_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'min'   => 1,
        'max'   => 30,
        'style' => 'width: 100px;'
        ),
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[recent_products_content_type]', array(
    'default'           => $options['recent_products_content_type'],
    'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[recent_products_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_recent_products_section',
    'type'              => 'select',
    'active_callback'   => 'teach_kiddo_pro_is_recent_products_section_enable',
    'choices'           => array(
        'product'           => esc_html__( 'Product', 'teach-kiddo-pro' ),
        'product-category'  => esc_html__( 'Product Category', 'teach-kiddo-pro' ),
        ),
) );

for( $i = 1 ; $i <= $options['recent_products_count']; $i++ ){

    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[recent_products_content_product_' . $i . ']', array(
        'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[recent_products_content_product_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Select Product %d', 'teach-kiddo-pro' ), $i ),
        'section'           => 'teach_kiddo_pro_recent_products_section',
        'choices'           => teach_kiddo_pro_product_choices(),
        'active_callback'   => 'teach_kiddo_pro_is_recent_products_section_content_product_enable',
    ) ) );
}

$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[recent_products_content_product_category]', array(
        'sanitize_callback' => 'absint',
    ) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[recent_products_content_product_category]', array(
    'label'             => esc_html__( 'Select Product Categories', 'teach-kiddo-pro' ),
    'description'       => esc_html__( 'Note: Press CTRL and select multiple category. Latest four posts will be shown from each selected category', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_recent_products_section',
    'taxonomy'          => 'product_cat',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'teach_kiddo_pro_is_recent_products_section_content_product_category_enable',
) ) );
