<?php
/**
 * service Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add service section
$wp_customize->add_section( 'teach_kiddo_pro_service_section', array(
	'title'             => esc_html__( 'Service','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Service Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
        );
    },
) );

// service content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_section_enable]', array(
	'default'			=> 	$options['service_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[service_section_enable]', array(
	'label'             => esc_html__( 'Service Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_service_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );


if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[service_section_enable]', array(
		'selector'            => '#service-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[service_section_enable]',
    ) );
}

// service sub title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[service_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_service_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[service_sub_title]', array(
		'selector'            => '#service-section .section-header p',
		'settings'            => 'teach_kiddo_pro_theme_options[service_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_service_sub_title_partial',
    ) );
}

// service title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[service_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_service_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[service_title]', array(
		'selector'            => '#service-section .section-header h2',
		'settings'            => 'teach_kiddo_pro_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_service_title_partial',
    ) );
}


// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['service_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[service_excerpt_length]', array(
	'label'       		=> esc_html__( 'Service Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in service posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_service_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_service_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );


// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_count]', array(
	'default'          	=> $options['service_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_service_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[service_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_service_section',
	'active_callback'   => 'teach_kiddo_pro_is_service_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// service content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_content_type]', array(
	'default'          	=> $options['service_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[service_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_service_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post' 		=> esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category' 	=> esc_html__( 'Category', 'teach-kiddo-pro' ),
	),
) );

for ( $i = 1; $i <= $options['service_count']; $i++ ) :

	// service note control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
		) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Icon_Picker( $wp_customize, 'teach_kiddo_pro_theme_options[service_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_service_section',
		'active_callback'	=> 'teach_kiddo_pro_is_service_section_enable',
		) ) );


	// service pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[service_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_service_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_service_section_content_page_enable',
	) ) );

	// service posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[service_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_service_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_service_section_content_post_enable',
	) ) );

    $wp_customize->add_setting( 'teach_kiddo_pro_theme_options[service_hr_'. $i .']', array(
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    $wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[service_hr_'. $i .']',
        array(
            'section'           => 'teach_kiddo_pro_service_section',
            'active_callback'   => 'teach_kiddo_pro_is_service_section_enable',
            'type'            => 'hr'
    ) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[service_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[service_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_service_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_service_section_content_category_enable'
) ) );