<?php
/**
* Slider Section options
*
* @package Theme Palace
* @subpackage Teach Kiddo Pro
* @since Teach Kiddo Pro 1.0.0
*/

// Add Slider section
$wp_customize->add_section( 'teach_kiddo_pro_slider_section', array(
	'title'             => esc_html__( 'Main Slider','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Slider Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	) );

// Slider content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_section_enable]', array(
	'default'			=> 	$options['slider_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[slider_section_enable]', array(
	'label'             => esc_html__( 'Slider Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
	) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[slider_section_enable]', array(
		'selector'            => '#featured-slider-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[slider_section_enable]',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_search_enable]', array(
	'default'			=> 	$options['slider_search_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[slider_search_enable]', array(
	'label'             => esc_html__( 'Slider Search Form Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
	) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_course_search_enable]', array(
	'default'			=> 	$options['slider_course_search_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[slider_course_search_enable]', array(
	'label'             => esc_html__( 'Enable Course Search', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
	) ) );

// Slider content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_autoplay]', array(
	'default'			=> 	$options['slider_autoplay'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[slider_autoplay]', array(
	'label'             => esc_html__( 'Auto Play Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	) ) );

// course btn title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_read_more]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_read_more'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_read_more]', array(
	'label'           	=> esc_html__( 'Read More Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_slider_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_btn_title'],
) );


$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_slider_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	'type'				=> 'text',
) );



// course btn link setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_slider_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	'type'				=> 'url',
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_count]', array(
	'default'          	=> $options['slider_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_slider_count',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'active_callback'   => 'teach_kiddo_pro_is_slider_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
	) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['slider_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_excerpt_length]', array(
	'label'       		=> esc_html__( 'Slider Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in slider posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_slider_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );

// Slider content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_content_type]', array(
	'default'          	=> $options['slider_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[slider_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_slider_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post' 		=> esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category' 	=> esc_html__( 'Category', 'teach-kiddo-pro' ),
		),
	) );

for ( $i = 1; $i <= $options['slider_count']; $i++ ) :

// slider pages drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_content_page_' . $i . ']', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[slider_content_page_' . $i . ']', array(
	'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'choices'			=> teach_kiddo_pro_page_choices(),
	'active_callback'	=> 'teach_kiddo_pro_is_slider_section_content_page_enable',
	) ) );

// slider posts drop down chooser control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[slider_content_post_' . $i . ']', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[slider_content_post_' . $i . ']', array(
	'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'choices'			=> teach_kiddo_pro_post_choices(),
	'active_callback'	=> 'teach_kiddo_pro_is_slider_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[slider_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
	) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[slider_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_slider_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_slider_section_content_category_enable'
	) ) );