<?php
/**
 * Latest Posts Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Latest Posts section
$wp_customize->add_section( 'teach_kiddo_pro_stories_section', array(
	'title'             => esc_html__( 'Stories','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Stories Section options.', 'teach-kiddo-pro' ),
	'panel'				=> 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_fourth_layout( $control )
        );
    },

) );

// Latest Posts content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_section_enable]', array(
	'default'			=> 	$options['stories_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[stories_section_enable]', array(
	'label'             => esc_html__( 'Stories Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_stories_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[stories_section_enable]', array(
		'selector'            => '#stories-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[stories_section_enable]',
    ) );
}

// Latest Posts btn label setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['stories_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_stories_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_stories_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[stories_title]', array(
		'selector'            => '#stories-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[stories_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_stories_title_partial',
    ) );
}

// Latest Posts btn label setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['stories_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_btn_label]', array(
	'label'           	=> esc_html__( 'Btn Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_stories_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_stories_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[stories_btn_label]', array(
		'selector'            => '#business-blog-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[stories_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_stories_btn_label_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_btn_link]', array(
	'label'           	=> esc_html__( 'Btn Url', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_stories_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_stories_section_enable',
	'type'				=> 'url',
) );

// content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_count]', array(
	'default'          	=> $options['stories_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_stories_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 30. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_stories_section',
	'active_callback'   => 'teach_kiddo_pro_is_stories_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 30,
		'style' => 'width: 100px;'
		),
) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['stories_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_excerpt_length]', array(
	'label'       		=> esc_html__( 'Blog Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in stories posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_stories_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_stories_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );

// Latest Posts content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_content_type]', array(
	'default'          	=> $options['stories_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[stories_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_stories_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_stories_section_enable',
	'choices'			=> array(
		'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
		'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
		'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
		),
) );

for ( $i = 1; $i <= $options['stories_count']; $i++ ) :
	// stories pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[stories_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_stories_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_stories_section_content_page_enable',
	) ) );

	// stories posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[stories_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[stories_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_stories_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_stories_section_content_post_enable',
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[stories_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[stories_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_stories_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_stories_section_content_category_enable'
) ) );