<?php
/**
 * Subscription Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Subscription section
$wp_customize->add_section( 'teach_kiddo_pro_subscription_section', array(
	'title'             => esc_html__( 'Subscription','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install Jetpack Plugin and activate subscription module.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
) );

// Subscription content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[subscription_section_enable]', array(
	'default'			=> 	$options['subscription_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[subscription_section_enable]', array(
	'label'             => esc_html__( 'Subscription Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_subscription_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[subscription_section_enable]', array(
		'selector'            => '#subscribe-now .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[subscription_section_enable]',
    ) );
}

// subscription  background image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[subscription_image]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[subscription_image]',
		array(
		'label'       		=> esc_html__( 'subscription Image', 'teach-kiddo-pro'),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'teach-kiddo-pro' ), 1920, 600 ),
		'section'     		=> 'teach_kiddo_pro_subscription_section',
		'active_callback'	=> 'teach_kiddo_pro_is_subscription_section_enable',
) ) );


// subscription title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[subscription_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[subscription_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_subscription_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[subscription_title]', array(
		'selector'            => '#subscribe-now h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[subscription_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_subscription_title_partial',
    ) );
}

// subscription description setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[subscription_description]', array(
	'sanitize_callback' => 'wp_kses_post',	
	'default'			=> $options['subscription_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[subscription_description]', array(
	'label'           	=> esc_html__( 'Description', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_subscription_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_subscription_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[subscription_description]', array(
		'selector'            => '#subscribe-now div.entry-content',
		'settings'            => 'teach_kiddo_pro_theme_options[subscription_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_subscription_description_partial',
    ) );
}

// subscription btn title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[subscription_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_btn_title'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[subscription_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_subscription_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );
