<?php
/**
 * Team Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add team section
$wp_customize->add_section( 'teach_kiddo_pro_team_section', array(
	'title'             => esc_html__( 'Team','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Team Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
        );
    },
) );

// team content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_section_enable]', array(
	'default'			=> 	$options['team_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[team_section_enable]', array(
	'label'             => esc_html__( 'Team Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_team_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[team_section_enable]', array(
		'selector'            => '#team-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[team_section_enable]',
    ) );
}


// team title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_team_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[team_title]', array(
		'selector'            => '#team-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[team_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_team_title_partial',
    ) );
}

// team sub title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_btn_title'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_team_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_team_section_enable',
	'type'				=> 'text',
) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_btn_url]', array(
	'label'           	=> esc_html__( 'Button Url', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_team_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_team_section_enable',
	'type'				=> 'url',
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_count]', array(
	'default'          	=> $options['team_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_team_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_count]', array(
	'label'             => esc_html__( 'Number of team', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_team_section',
	'active_callback'   => 'teach_kiddo_pro_is_team_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

// team content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_content_type]', array(
	'default'          	=> $options['team_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_team_section_enable',
	'choices'			=> teach_kiddo_pro_popular_team_content_type(),
) );

for ( $i = 1; $i <= $options['team_count']; $i++ ) :

	// team pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[team_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_team_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_page_enable',
	) ) );
	if ( class_exists( 'TP_Education' ) ) {
		// team pages drop down chooser control and setting
		$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_content_team_' . $i . ']', array(
			'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
		) );

		$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[team_content_team_' . $i . ']', array(
			'label'             => sprintf( esc_html__( 'Select Teacher %d', 'teach-kiddo-pro' ), $i ),
			'section'           => 'teach_kiddo_pro_team_section',
			'choices'			=> teach_kiddo_pro_team_choices(),
			'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_team_enable',
		) ) );
	}
	

	// team posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[team_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_team_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_post_enable',
	) ) );

	// team custom content
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_position_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[team_position_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Position %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_team_section',
		'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_position_social_enable',
	) );

	// team social
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_social_' . $i. ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Multi_Input_Custom_Control( $wp_customize, 'teach_kiddo_pro_theme_options[team_social_' . $i. ']', array(
		'label'             => esc_html__( 'Social ', 'teach-kiddo-pro' ),
		'button_text'       => esc_html__( 'Add social.', 'teach-kiddo-pro' ),
		'section'           => 'teach_kiddo_pro_team_section',
		'active_callback' 	=> 'teach_kiddo_pro_is_team_section_content_position_social_enable',
	) ) );

// team hr setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[team_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[team_hr_'. $i .']',
		array(
			'section'         => 'teach_kiddo_pro_team_section',
			'active_callback' => 'teach_kiddo_pro_is_team_section_enable',
			'type'			  => 'hr'
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[team_content_team_category]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[team_content_team_category]', array(
	'label'             => esc_html__( 'Select Course Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_team_section',
	'type'              => 'dropdown-taxonomies',
	'taxonomy'          => 'tp-team-category',
	'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_team_category_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[team_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[team_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_team_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_team_section_content_category_enable'
) ) );

