<?php
/**
 * Testimonial Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Testimonial section
$wp_customize->add_section( 'teach_kiddo_pro_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            teach_kiddo_pro_is_default_layout( $control )
            ||
            teach_kiddo_pro_is_second_layout( $control )
            ||
            teach_kiddo_pro_is_third_layout( $control )
            ||
            teach_kiddo_pro_is_all_layout( $control )
        );
    },
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Testimonial Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_testimonial_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[testimonial_section_enable]', array(
		'selector'            => '#testimonial-section .tooltiptext',
		'settings'            => 'teach_kiddo_pro_theme_options[testimonial_section_enable]',
    ) );
}

// testimonial title setting and control
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['testimonial_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[testimonial_title]', array(
	'label'           	=> esc_html__( 'Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_testimonial_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[testimonial_title]', array(
		'selector'            => '#testimonial-section h2.section-title',
		'settings'            => 'teach_kiddo_pro_theme_options[testimonial_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_testimonial_title_partial',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_count]', array(
	'default'          	=> $options['testimonial_count'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_testimonial_count',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[testimonial_count]', array(
	'label'             => esc_html__( 'Number of Testimonials', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_testimonial_section',
	'active_callback'   => 'teach_kiddo_pro_is_testimonial_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['testimonial_excerpt_length'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[testimonial_excerpt_length]', array(
	'label'       		=> esc_html__( 'Testimonial Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in testimonial posts.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_testimonial_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_testimonial_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
		),
	) );

// Testimonial content type control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_content_type]', array(
	'default'          	=> $options['testimonial_content_type'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_select',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[testimonial_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'teach_kiddo_pro_is_testimonial_section_enable',
	'choices'			=> teach_kiddo_pro_testimonial_content_type(),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'teach_kiddo_pro_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Taxonomies_Control( $wp_customize,'teach_kiddo_pro_theme_options[testimonial_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'teach-kiddo-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_testimonial_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'teach_kiddo_pro_is_testimonial_section_content_category_enable'
) ) );

for ( $i = 1; $i <= $options['testimonial_count']; $i++ ) :
	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_testimonial_section',
		'choices'			=> teach_kiddo_pro_page_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_testimonial_section_content_page_enable',
	) ) );

	// testimonial posts drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_testimonial_section',
		'choices'			=> teach_kiddo_pro_post_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_testimonial_section_content_post_enable',
	) ) );

	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_content_testimonial_' . $i . ']', array(
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Dropdown_Chooser( $wp_customize, 'teach_kiddo_pro_theme_options[testimonial_content_testimonial_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Testimonial %d', 'teach-kiddo-pro' ), $i ),
		'section'           => 'teach_kiddo_pro_testimonial_section',
		'choices'			=> teach_kiddo_pro_testimonial_choices(),
		'active_callback'	=> 'teach_kiddo_pro_is_testimonial_section_content_testimonial_enable',
	) ) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'teach_kiddo_pro_theme_options[testimonial_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'position %d', 'teach-kiddo-pro' ), $i ),
		'section'        	=> 'teach_kiddo_pro_testimonial_section',
		'active_callback' 	=> 'teach_kiddo_pro_is_testimonial_position_section_enable',
		'type'				=> 'text',
	) );

	// testimonial hr setting and control
	$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Teach_Kiddo_Pro_Customize_Horizontal_Line( $wp_customize, 'teach_kiddo_pro_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'teach_kiddo_pro_testimonial_section',
			'active_callback' => 'teach_kiddo_pro_is_testimonial_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;

