<?php
/**
 * Topbar Section options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add Topbar section
$wp_customize->add_section( 'teach_kiddo_pro_topbar_section', array(
	'title'             => esc_html__( 'Topbar','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Topbar Section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_front_page_panel',
) );

// topbar enable/disable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_section_enable]', array(
	'default'			=> 	$options['topbar_section_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[topbar_section_enable]', array(
	'label'             => esc_html__( 'Topbar Section Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_topbar_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

// Topbar content enable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[social_menu_enable]', array(
	'default'			=> 	$options['social_menu_enable'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[social_menu_enable]', array(
	'label'             => esc_html__( 'Social Menu Enable', 'teach-kiddo-pro' ),
	'description'       => sprintf( '%1$s <a class="topbar-menu-trigger" href="#"> %2$s </a> %3$s', esc_html__( 'Note: To show secondary and social menu.', 'teach-kiddo-pro' ), esc_html__( 'Click Here', 'teach-kiddo-pro' ), esc_html__( 'to create menu', 'teach-kiddo-pro' ) ),
	'section'           => 'teach_kiddo_pro_topbar_section',
	'active_callback'   => 'teach_kiddo_pro_is_topbar_section_enable',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_field_1]', array(
    'default'           =>  $options['topbar_field_1'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control('teach_kiddo_pro_theme_options[topbar_field_1]', array(
    'label'             => esc_html__( 'Contact Number', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_topbar_section',
    'type'              => 'text',
    'active_callback'   => 'teach_kiddo_pro_is_topbar_section_enable',
 ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_field_2]', array(
    'default'           =>  $options['topbar_field_2'],
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control('teach_kiddo_pro_theme_options[topbar_field_2]', array(
    'label'             => esc_html__( 'Contact Email', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_topbar_section',
    'type'              => 'text',
    'active_callback'   => 'teach_kiddo_pro_is_topbar_section_enable',
 ) );

 // topbar enable/disable control and setting
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_btn]', array(
	'default'			=> 	$options['topbar_btn'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[topbar_btn]', array(
	'label'             => esc_html__( 'Topbar Button Enable', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_topbar_section',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
	'active_callback'   => 'teach_kiddo_pro_is_topbar_section_enable',
) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_btn_title]', array(
    'default'           =>  $options['topbar_btn_title'],
    'sanitize_callback' => 'sanitize_text_field',
    'transport'			=> 'postMessage',
) );

$wp_customize->add_control('teach_kiddo_pro_theme_options[topbar_btn_title]', array(
    'label'             => esc_html__( 'Button Label', 'teach-kiddo-pro' ),
    'section'           => 'teach_kiddo_pro_topbar_section',
    'type'              => 'text',
    'active_callback'   => 'teach_kiddo_pro_is_topbar_btn_enable',
 ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[topbar_btn_title]', array(
		'selector'            => '.latest-content-title .page-header h2',
		'settings'            => 'teach_kiddo_pro_theme_options[topbar_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_topbar_btn_title_partial',
    ) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[topbar_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'			=> $options['topbar_btn_url']
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[topbar_btn_url]', array(
	'label'           	=> esc_html__( 'Button Url', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_topbar_section',
	'active_callback' 	=> 'teach_kiddo_pro_is_topbar_btn_enable',
	'type'				=> 'url',
) );