<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'teach_kiddo_pro_archive_section', array(
	'title'             => esc_html__( 'Blog/Archive','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Archive section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_theme_options_panel',
) );

// Your latest posts title setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[your_latest_posts_title]', array(
	'default'           => $options['your_latest_posts_title'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[your_latest_posts_title]', array(
	'label'             => esc_html__( 'Your Latest Posts Title', 'teach-kiddo-pro' ),
	'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_archive_section',
	'type'				=> 'text',
	'active_callback'   => 'teach_kiddo_pro_is_latest_posts'
) );

// Archive image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_image]', array(
	'default'				=> $options['hide_image'],
	'sanitize_callback'		=>'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_image]', array(
		'label'			=> esc_html__( 'Hide Image', 'teach-kiddo-pro' ),
		'section'		=> 'teach_kiddo_pro_archive_section',
		'on_off_label'	=> teach_kiddo_pro_hide_options(),
	) ) );

// Archive category setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_category]', array(
	'default'           => $options['hide_category'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_archive_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_date]', array(
	'default'           => $options['hide_date'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_date]', array(
	'label'             => esc_html__( 'Hide Date', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_archive_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// Archive post title setting and controll
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_title]', array(
	'default'			=> $options['hide_title'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_title]',
	array(
		'label'			=> esc_html__( 'Hide Title', 'teach-kiddo-pro' ),
		'section'		=> 'teach_kiddo_pro_archive_section',
		'on_off_label'	=> teach_kiddo_pro_hide_options(),
		)
 ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[archive_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['archive_btn_title'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[archive_btn_title]', array(
	'label'           	=> esc_html__( 'Btn Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_archive_section',
	'type'				=> 'text',
) );