<?php
/**
 * banner options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add banner section
$wp_customize->add_section( 'teach_kiddo_pro_banner_section', array(
	'title'             => esc_html__( 'Blog/banner','teach-kiddo-pro' ),
	'description'       => esc_html__( 'banner section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_theme_options_panel',
) );


// banner image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_single_page_banner]', array(
	'default'				=> $options['hide_single_page_banner'],
	'sanitize_callback'		=>'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_single_page_banner]', array(
		'label'			=> esc_html__( 'Hide Single Page Banner', 'teach-kiddo-pro' ),
		'section'		=> 'teach_kiddo_pro_banner_section',
		'on_off_label'	=> teach_kiddo_pro_hide_options(),
	) ) );

// banner image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[hide_single_post_banner]', array(
	'default'				=> $options['hide_single_post_banner'],
	'sanitize_callback'		=>'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[hide_single_post_banner]', array(
		'label'			=> esc_html__( 'Hide Single Post Banner', 'teach-kiddo-pro' ),
		'section'		=> 'teach_kiddo_pro_banner_section',
		'on_off_label'	=> teach_kiddo_pro_hide_options(),
	) ) );

