<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

$wp_customize->add_section( 'teach_kiddo_pro_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'teach-kiddo-pro' ),
	'section'          	=> 'teach_kiddo_pro_breadcrumb',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'teach-kiddo-pro' ),
	'active_callback' 	=> 'teach_kiddo_pro_is_breadcrumb_enable',
	'section'          	=> 'teach_kiddo_pro_breadcrumb',
) );
