<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'teach_kiddo_pro_excerpt_section', array(
	'title'             => esc_html__( 'Excerpt','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Excerpt section options.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_theme_options_panel',
) );


// long Excerpt length setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[long_excerpt_length]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_number_range',
	'validate_callback' => 'teach_kiddo_pro_validate_long_excerpt',
	'default'			=> $options['long_excerpt_length'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[long_excerpt_length]', array(
	'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'teach-kiddo-pro' ),
	'description' 		=> esc_html__( 'Total words to be displayed in archive page/search page.', 'teach-kiddo-pro' ),
	'section'     		=> 'teach_kiddo_pro_excerpt_section',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
	),
) );
