<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'teach_kiddo_pro_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'teach-kiddo-pro' ),
		'priority'   			=> 900,
		'panel'      			=> 'teach_kiddo_pro_theme_options_panel',
	)
);


// footer image setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[footer_image]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_image'
	) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'teach_kiddo_pro_theme_options[footer_image]',
	array(
		'label'       		=> esc_html__( 'Footer Background', 'teach-kiddo-pro' ),
		'section'     		=> 'teach_kiddo_pro_section_footer',
		) ) );

// footer copyright text
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'teach_kiddo_pro_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'teach_kiddo_pro_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'teach-kiddo-pro' ),
		'section'    			=> 'teach_kiddo_pro_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[copyright_text]', array(
		'selector'            => '#colophon .site-info span.copyright',
		'settings'            => 'teach_kiddo_pro_theme_options[copyright_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_copyright_text_partial',
    ) );
}

// scroll top visible
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[scroll_top_visible]',
	array(
		'default'       		=> $options['scroll_top_visible'],
		'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[scroll_top_visible]',
    array(
		'label'      			=> esc_html__( 'Display Scroll Top Button', 'teach-kiddo-pro' ),
		'section'    			=> 'teach_kiddo_pro_section_footer',
		'on_off_label' 		=> teach_kiddo_pro_switch_options(),
    )
) );