<?php
/**
 * Loader options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

$wp_customize->add_section( 'teach_kiddo_pro_loader', array(
	'title'            		=> esc_html__( 'Loader','teach-kiddo-pro' ),
	'description'      		=> esc_html__( 'Loader section options.', 'teach-kiddo-pro' ),
	'panel'            		=> 'teach_kiddo_pro_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[loader_enable]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'teach-kiddo-pro' ),
	'section'             	=> 'teach_kiddo_pro_loader',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'teach_kiddo_pro_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'teach-kiddo-pro' ),
	'section'         		=> 'teach_kiddo_pro_loader',
	'type'					=> 'select',
	'choices'				=> teach_kiddo_pro_get_spinner_list(),
	'active_callback' 		=> 'teach_kiddo_pro_is_loader_enable',
) );
