<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'teach_kiddo_pro_menu', array(
	'title'             => esc_html__('Header Menu','teach-kiddo-pro'),
	'description'       => esc_html__( 'Header Menu options.', 'teach-kiddo-pro' ),
	'panel'             => 'nav_menus',
) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	'default'           => $options['menu_sticky'],
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[menu_sticky]', array(
	'label'             => esc_html__( 'Make Menu Sticky', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_menu',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[menu_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['menu_btn_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[menu_btn_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_menu',
	'type'				=> 'text',
	) );

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'teach_kiddo_pro_theme_options[menu_btn_title]', array(
		'selector'            => '#primary-menu .custom-button',
		'settings'            => 'teach_kiddo_pro_theme_options[menu_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'teach_kiddo_pro_menu_btn_title_partial',
		) );
}

$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[menu_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'			=>  $options['menu_btn_url'],
	) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[menu_btn_url]', array(
	'label'           	=> esc_html__( 'Btn Url', 'teach-kiddo-pro' ),
	'section'        	=> 'teach_kiddo_pro_menu',
	'type'				=> 'url',
	) );