<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'teach_kiddo_pro_pagination', array(
	'title'               => esc_html__('Pagination','teach-kiddo-pro'),
	'description'         => esc_html__( 'Pagination section options.', 'teach-kiddo-pro' ),
	'panel'               => 'teach_kiddo_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'teach-kiddo-pro' ),
	'section'             => 'teach_kiddo_pro_pagination',
	'on_off_label' 		=> teach_kiddo_pro_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'teach_kiddo_pro_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'teach-kiddo-pro' ),
	'section'             => 'teach_kiddo_pro_pagination',
	'type'                => 'select',
	'choices'			  => teach_kiddo_pro_pagination_options(),
	'active_callback'	  => 'teach_kiddo_pro_is_pagination_enable',
) );
