<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'teach_kiddo_pro_reset_section', array(
	'title'             => esc_html__('Reset all settings','teach-kiddo-pro'),
	'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'teach-kiddo-pro' ),
) );

// Add reset enable setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[reset_options]', array(
	'default'           => $options['reset_options'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_checkbox',
	'transport'			  => 'postMessage',
) );

$wp_customize->add_control( 'teach_kiddo_pro_theme_options[reset_options]', array(
	'label'             => esc_html__( 'Check to reset all settings', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_reset_section',
	'type'              => 'checkbox',
) );
