<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'teach_kiddo_pro_single_post_section', array(
	'title'             => esc_html__( 'Single Post','teach-kiddo-pro' ),
	'description'       => esc_html__( 'Options to change the single posts globally.', 'teach-kiddo-pro' ),
	'panel'             => 'teach_kiddo_pro_theme_options_panel',
) );

// Tourableve date meta setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[single_post_hide_date]', array(
	'default'           => $options['single_post_hide_date'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_date]', array(
	'label'             => esc_html__( 'Hide Date', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_single_post_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// Tourableve author meta setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[single_post_hide_author]', array(
	'default'           => $options['single_post_hide_author'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_author]', array(
	'label'             => esc_html__( 'Hide Author', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_single_post_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// Tourableve author category setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[single_post_hide_category]', array(
	'default'           => $options['single_post_hide_category'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_single_post_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// Tourableve tag category setting and control.
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[single_post_hide_tags]', array(
	'default'           => $options['single_post_hide_tags'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_tags]', array(
	'label'             => esc_html__( 'Hide Tag', 'teach-kiddo-pro' ),
	'section'           => 'teach_kiddo_pro_single_post_section',
	'on_off_label' 		=> teach_kiddo_pro_hide_options(),
) ) );

// single post image setting and controll
$wp_customize->add_setting( 'teach_kiddo_pro_theme_options[single_post_hide_image]', array(
	'default'			=> $options['single_post_hide_image'],
	'sanitize_callback'	=> 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_image]', array(
	'label'		=> esc_html__( 'Hide Image', 'teach-kiddo-pro' ),
	'section'	=> 'teach_kiddo_pro_single_post_section',
	'on_off_label'	=> teach_kiddo_pro_hide_options(),
	) ) );

// single post description setting and control
$wp_customize->add_Setting( 'teach_kiddo_pro_theme_options[single_post_hide_description]', array(
	'default'		=> $options['single_post_hide_description'],
	'sanitize_callback' => 'teach_kiddo_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Teach_Kiddo_Pro_Switch_Control( $wp_customize, 'teach_kiddo_pro_theme_options[single_post_hide_description]', array(
	'label'		=> esc_html__( 'Hide Description', 'teach-kiddo-pro' ),
	'section'	=> 'teach_kiddo_pro_single_post_section',
	'on_off_label'	=> teach_kiddo_pro_hide_options(),
	) ) );