<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Teach Kiddo Pro
* @since Teach Kiddo Pro 1.0.0
*/

if ( ! function_exists( 'teach_kiddo_pro_validate_long_excerpt' ) ) :
  function teach_kiddo_pro_validate_long_excerpt( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 5 ) {
		 $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 100 ) {
		 $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_slider_count' ) ) :
  function teach_kiddo_pro_validate_slider_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_service_count' ) ) :
  function teach_kiddo_pro_validate_service_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 2 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of service is 2', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 12 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of service is 12', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_testimonial_count' ) ) :
  function teach_kiddo_pro_validate_testimonial_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of testimonial is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of testimonial is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_blog_count' ) ) :
  function teach_kiddo_pro_validate_blog_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_team_count' ) ) :
  function teach_kiddo_pro_validate_team_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_gallery_count' ) ) :
  function teach_kiddo_pro_validate_gallery_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_featured_count' ) ) :
  function teach_kiddo_pro_validate_featured_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_career_count' ) ) :
  function teach_kiddo_pro_validate_career_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_featured_products_count' ) ) :
  function teach_kiddo_pro_validate_featured_products_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 2 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_recent_products_count' ) ) :
  function teach_kiddo_pro_validate_recent_products_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 30 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_latest_products_count' ) ) :
  function teach_kiddo_pro_validate_latest_products_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 30 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_latest_posts_count' ) ) :
  function teach_kiddo_pro_validate_latest_posts_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 3 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 30 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_featured_posts_count' ) ) :
  function teach_kiddo_pro_validate_featured_posts_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 30 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_popular_posts_count' ) ) :
  function teach_kiddo_pro_validate_popular_posts_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 3 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 30 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_counter_count' ) ) :
  function teach_kiddo_pro_validate_counter_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_medical_featured_count' ) ) :
  function teach_kiddo_pro_validate_medical_featured_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 50 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;

if ( ! function_exists( 'teach_kiddo_pro_validate_client_count' ) ) :
  function teach_kiddo_pro_validate_client_count( $validity, $value ){
		 $value = intval( $value );
	 if ( empty( $value ) || ! is_numeric( $value ) ) {
		 $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'teach-kiddo-pro' ) );
	 } elseif ( $value < 1 ) {
		 $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of logo is 1', 'teach-kiddo-pro' ) );
	 } elseif ( $value > 12 ) {
		 $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of logo is 12', 'teach-kiddo-pro' ) );
	 }
	 return $validity;
  }
endif;