<?php
// /**
//  * Demo Import.
//  *
//  * This is the template that includes all the other files for core featured of Theme Palace
//  *
//  * @package Theme Palace
//  * @subpackage Teach Kiddo Pro
//  * @since Teach Kiddo Pro 1.0.0
//  */


function teach_kiddo_pro_ctdi_plugin_page_setup( $default_settings ) {
    $default_settings['menu_title']  = esc_html__( 'Theme Palace Demo Import' , 'teach-kiddo-pro' );

    return $default_settings;
}
add_filter( 'cp-ctdi/plugin_page_setup', 'teach_kiddo_pro_ctdi_plugin_page_setup' );


function teach_kiddo_pro_ctdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Pro', 'teach-kiddo-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/pro/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/pro/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/pro/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo-data/pro/screenshot.jpg',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'teach-kiddo-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/teach-kiddo-pro',
        ),
        array(
            'import_file_name'             => esc_html__( 'Blog', 'teach-kiddo-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/blog/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/blog/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/blog/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo-data/blog/screenshot.jpg',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'teach-kiddo-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/teach-kiddo-blog',
        ),
        array(
            'import_file_name'             => esc_html__( 'Dark', 'teach-kiddo-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/dark/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/dark/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/dark/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo-data/dark/screenshot.jpg',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'teach-kiddo-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/teach-kiddo-dark',
        ),
         array(
            'import_file_name'             => esc_html__( 'Shop', 'teach-kiddo-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/shop/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/shop/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/shop/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo-data/shop/screenshot.jpg',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'teach-kiddo-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/teach-kiddo-shop',
        ),
         array(
            'import_file_name'             => esc_html__( 'business', 'teach-kiddo-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/business/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/business/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/business/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo-data/business/screenshot.jpg',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'teach-kiddo-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/teach-kiddo-business',
        ),
    );
}
add_filter( 'cp-ctdi/import_files', 'teach_kiddo_pro_ctdi_import_files' );



function teach_kiddo_pro_ctdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
    $social = get_term_by('name', 'Social', 'nav_menu');

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            'social' => $social->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'cp-ctdi/after_import', 'teach_kiddo_pro_ctdi_after_import_setup' );

// add_action( 'cp-ctdi/enable_wp_customize_save_hooks', '__return_true' );