<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function teach_kiddo_pro_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function teach_kiddo_pro_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of products for post choices.
 * @return Array Array of post ids and name.
 */
function teach_kiddo_pro_product_choices() {
    $posts = get_posts( array( 'numberposts' => -1, 'post_type' => 'product' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of posts for course choices.
 * @return Array Array of course ids and name.
 */
function teach_kiddo_pro_course_choices() {
    $courses = get_posts( array( 'numberposts' => -1, 'post_type'=>'tp-course' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $courses as $course ) {
        $choices[ $course->ID ] = $course->post_title;
    }
    return  $choices;
}

/**
 * List of posts for course choices.
 * @return Array Array of course ids and name.
 */
function teach_kiddo_pro_event_choices() {
    $events = get_posts( array( 'numberposts' => -1, 'post_type'=>'tp-event' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $events as $event ) {
        $choices[ $event->ID ] = $event->post_title;
    }
    return  $choices;
}

/**
 * List of posts for team choices.
 * @return Array Array of team ids and name.
 */
function teach_kiddo_pro_team_choices() {
    $teams = get_posts( array( 'numberposts' => -1, 'post_type'=>'tp-team' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $teams as $team ) {
        $choices[ $team->ID ] = $team->post_title;
    }
    return  $choices;
}

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function teach_kiddo_pro_testimonial_choices() {
    $testimonials = get_posts( array( 'numberposts' => -1, 'post_type'=>'tp-testimonial' ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'teach-kiddo-pro' );
    foreach ( $testimonials as $testimonial ) {
        $choices[ $testimonial->ID ] = $testimonial->post_title;
    }
    return  $choices;
}


if ( ! function_exists( 'teach_kiddo_pro_typography_options' ) ) :
    function teach_kiddo_pro_typography_options(){
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'teach-kiddo-pro' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
     // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '+', $family_str_arr );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return $font_family_arr;
}
endif;

if ( ! function_exists( 'teach_kiddo_pro_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function teach_kiddo_pro_selected_sidebar() {
        $teach_kiddo_pro_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'teach-kiddo-pro' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'teach-kiddo-pro' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'teach-kiddo-pro' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'teach-kiddo-pro' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'teach-kiddo-pro' ),
        );

        $output = apply_filters( 'teach_kiddo_pro_selected_sidebar', $teach_kiddo_pro_selected_sidebar );

        return $output;
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function teach_kiddo_pro_site_layout() {
        $teach_kiddo_pro_site_layout = array(
            'wide-layout'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
            'frame-layout' => get_template_directory_uri() . '/assets/images/framed.png',
        );

        $output = apply_filters( 'teach_kiddo_pro_site_layout', $teach_kiddo_pro_site_layout );
        return $output;
    }
endif;


if ( ! function_exists( 'teach_kiddo_pro_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function teach_kiddo_pro_global_sidebar_position() {
        $teach_kiddo_pro_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'teach_kiddo_pro_global_sidebar_position', $teach_kiddo_pro_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'teach_kiddo_pro_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function teach_kiddo_pro_sidebar_position() {
        $teach_kiddo_pro_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
            'no-sidebar-content'   => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'teach_kiddo_pro_sidebar_position', $teach_kiddo_pro_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'teach_kiddo_pro_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function teach_kiddo_pro_pagination_options() {
        $teach_kiddo_pro_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'teach-kiddo-pro' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'teach-kiddo-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'teach-kiddo-pro' ),
        );

        $output = apply_filters( 'teach_kiddo_pro_pagination_options', $teach_kiddo_pro_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function teach_kiddo_pro_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'teach-kiddo-pro' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'teach-kiddo-pro' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'teach-kiddo-pro' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'teach-kiddo-pro' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'teach-kiddo-pro' ),
            'spinner-dots'          => esc_html__( 'Dots', 'teach-kiddo-pro' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'teach-kiddo-pro' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'teach-kiddo-pro' ),
        );
        return apply_filters( 'teach_kiddo_pro_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function teach_kiddo_pro_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'teach-kiddo-pro' ),
            'off'       => esc_html__( 'Disable', 'teach-kiddo-pro' )
        );
        return apply_filters( 'teach_kiddo_pro_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function teach_kiddo_pro_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'teach-kiddo-pro' ),
            'off'       => esc_html__( 'No', 'teach-kiddo-pro' )
        );
        return apply_filters( 'teach_kiddo_pro_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function teach_kiddo_pro_sortable_sections() {
        $sections = array();
        $sections = array(
            'slider'                => esc_html__( 'Main Slider', 'teach-kiddo-pro' ),
            'service'               => esc_html__( 'Service Section', 'teach-kiddo-pro' ),
            'contact'               => esc_html__( 'Conact Section', 'teach-kiddo-pro' ),
            'testimonial'           => esc_html__( 'Testimonial Section', 'teach-kiddo-pro' ),
            'subscription'          => esc_html__( 'Subscription Section', 'teach-kiddo-pro' ),
            'blog'                  => esc_html__( 'Blog Section', 'teach-kiddo-pro' ),
            'team'                  => esc_html__( 'Team Section', 'teach-kiddo-pro' ),
            'gallery'               => esc_html__( 'Gallery Section', 'teach-kiddo-pro' ),
            'client'                => esc_html__( 'Client Section', 'teach-kiddo-pro' ),
            'featured_products'     => esc_html__( 'Featured Products Section', 'teach-kiddo-pro' ),
            'recent_products'       => esc_html__( 'Recent Products Section', 'teach-kiddo-pro' ),
            'latest_products'       => esc_html__( 'Latest Products Section', 'teach-kiddo-pro' ),
            'latest_posts'          => esc_html__( 'Latest Posts Section', 'teach-kiddo-pro' ),
            'featured_posts'        => esc_html__( 'Featured Posts Section', 'teach-kiddo-pro' ),
            'popular_posts'         => esc_html__( 'Popular Posts Section', 'teach-kiddo-pro' ),
            'promotion'             => esc_html__( 'Promotion Section', 'teach-kiddo-pro' ),
            'counter'               => esc_html__( 'Counter Section', 'teach-kiddo-pro' ),
            'popular_course'        => esc_html__( 'Popular Course Section', 'teach-kiddo-pro' ),
            'featured_course'       => esc_html__( 'Featured Course Section', 'teach-kiddo-pro' ),
            'recent_posts'          => esc_html__( 'Recent Posts Section', 'teach-kiddo-pro' ),
            'stories'               => esc_html__( 'Stoires Section', 'teach-kiddo-pro' ),
            'popular_products'       => esc_html__( 'Popular Products Section', 'teach-kiddo-pro' ),
            'products_collection'   => esc_html__( 'Products Collection Section', 'teach-kiddo-pro' ),
            'trending_products'     => esc_html__( 'Trending Products Section', 'teach-kiddo-pro' ),
        );
        return apply_filters( 'teach_kiddo_pro_sortable_sections', $sections );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_popular_course_content_type' ) ) :
    /**
     * Destination Options
     * @return array site gallery options
     */
    function teach_kiddo_pro_popular_course_content_type() {
        $teach_kiddo_pro_popular_course_content_type = array(
            'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
            'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
            'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
        );

        if ( class_exists( 'TP_Education' ) ) {
            $teach_kiddo_pro_popular_course_content_type_plugin = array();

            if ( post_type_exists( 'tp-course' ) ) {
                $teach_kiddo_pro_popular_course_content_type_plugin['course'] = esc_html__('Course', 'teach-kiddo-pro');
                $teach_kiddo_pro_popular_course_content_type_plugin['course-category'] = esc_html__('Course Category', 'teach-kiddo-pro');
            }
        }
         if ( !class_exists('TP_Education')) {
            $teach_kiddo_pro_popular_course_content_type_plugin = array();
        }
        $teach_kiddo_pro_popular_course_content_type = array_merge( $teach_kiddo_pro_popular_course_content_type, $teach_kiddo_pro_popular_course_content_type_plugin );
        $output = apply_filters( 'teach_kiddo_pro_popular_course_content_type', $teach_kiddo_pro_popular_course_content_type );


        return $output;
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_popular_team_content_type' ) ) :
    /**
     * Destination Options
     * @return array site gallery options
     */
    function teach_kiddo_pro_popular_team_content_type() {
        $teach_kiddo_pro_popular_team_content_type = array(
            'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
            'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
            'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
        );

        if ( class_exists( 'TP_Education' ) ) {
            $custom_choices = array();
            if ( post_type_exists( 'tp-team' ) ) {
               $custom_choices['tp-team']   =  esc_html__( 'Team', 'teach-kiddo-pro' );
               $custom_choices['tp-team-category']   =  esc_html__( 'Team Category', 'teach-kiddo-pro' );    
            }
        }
        if ( !class_exists('TP_Education')) {
            $custom_choices = array();
        }
        $teach_kiddo_pro_popular_team_content_type = array_merge( $teach_kiddo_pro_popular_team_content_type, $custom_choices );
        $output = apply_filters( 'teach_kiddo_pro_popular_team_content_type', $teach_kiddo_pro_popular_team_content_type );


        return $output;
    }
endif;

function teach_kiddo_pro_is_promotion_section_content_choice(){

    $teach_kiddo_pro_is_promotion_section_content_choice = array(
        'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
        'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
        'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
    );

    if ( class_exists( 'Woocommerce' ) ) {
        $custom_choices = array();
        if ( post_type_exists( 'tp-team' ) ) {
           $custom_choices['product']   =  esc_html__( 'product', 'teach-kiddo-pro' ); 
        }
    }
    if ( !class_exists('Woocommerce')) {
        $custom_choices = array();
    }
    $teach_kiddo_pro_is_promotion_section_content_choice = array_merge( $teach_kiddo_pro_is_promotion_section_content_choice, $custom_choices );
    $output = apply_filters( 'teach_kiddo_pro_is_promotion_section_content_choice', $teach_kiddo_pro_is_promotion_section_content_choice );


    return $output;
}



if ( ! function_exists( 'teach_kiddo_pro_popular_event_content_type' ) ) :
    /**
     * Destination Options
     * @return array site gallery options
     */
    function teach_kiddo_pro_popular_event_content_type() {
        $teach_kiddo_pro_popular_event_content_type = array(
                'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
                'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
                'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
            ) ;
        if ( class_exists( 'TP_Education' ) ) {
            $teach_kiddo_pro_popular_event_content_type = array_merge($teach_kiddo_pro_popular_event_content_type, array(
                'event'            => esc_html__( 'Event', 'teach-kiddo-pro' ),
                'event-category'   => esc_html__( 'Event Category', 'teach-kiddo-pro' ),
                ) );
        }
       
        $output = apply_filters( 'teach_kiddo_pro_popular_event_content_type', $teach_kiddo_pro_popular_event_content_type );


        return $output;
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_testimonial_content_type' ) ) :
    /**
     * Package Options
     * @return array site testimonial options
     */
    function teach_kiddo_pro_testimonial_content_type() {
        $teach_kiddo_pro_testimonial_content_type = array(
            'page'      => esc_html__( 'Page', 'teach-kiddo-pro' ),
            'post'      => esc_html__( 'Post', 'teach-kiddo-pro' ),
            'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
        );

        if ( class_exists( 'TP_Education' ) ) {
            $teach_kiddo_pro_testimonial_content_type = array_merge( $teach_kiddo_pro_testimonial_content_type, array(
                'testimonial'            => esc_html__( 'Testimonial', 'teach-kiddo-pro' ),
                ) );
        }

        $output = apply_filters( 'teach_kiddo_pro_testimonial_content_type', $teach_kiddo_pro_testimonial_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_career_content_type' ) ) :
    /**
     * Package Options
     * @return array site career options
     */
    function teach_kiddo_pro_career_content_type() {
        $teach_kiddo_pro_career_content_type = array(
            'category'  => esc_html__( 'Category', 'teach-kiddo-pro' ),
        );

        if ( class_exists( 'TP_Education' ) ) {
            $teach_kiddo_pro_career_content_type = array_merge( $teach_kiddo_pro_career_content_type, array(
                'course-category'   => esc_html__( 'Course Category', 'teach-kiddo-pro' ),
                ) );
        }

        $output = apply_filters( 'teach_kiddo_pro_career_content_type', $teach_kiddo_pro_career_content_type );

        return $output;
    }
endif;


function teach_kiddo_pro_course_searchform( ) {
    ?>
   <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
        <label>
            <span class="screen-reader-text"><?php echo esc_html_x( 'Search for:', 'label', 'teach-kiddo-pro' ); ?></span>
        </label>
        <input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search your favourite courses  &hellip;', 'placeholder', 'teach-kiddo-pro' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
        <button type="submit" class="search-submit"><?php echo esc_html_x( 'Search', 'submit button', 'teach-kiddo-pro' ); ?></button>
        <input type="hidden" name="post_type" value="tp-course" />
    </form>
<?php }