<?php
/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_about_section' ) ) :
    /**
    * Add about section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_about_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if about is enabled on frontpage
        $about_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'about_section_enable' );

        if ( true !== $about_enable ) {
            return false;
        }
        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

 
        teach_kiddo_pro_render_about_section( $section_details );

    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_about_section_details' ) ) :
    /**
    * about section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input about section details.
    */
    function teach_kiddo_pro_get_about_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $about_content_type  = $options['about_content_type'];
        $content = array();
        switch ( $about_content_type ) {
            

            case 'page':
                $page_id = ! empty( $options['about_content_page'] ) ? $options['about_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['about_content_post'] ) ? $options['about_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['about_excerpt_length'] );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about section content details.
add_filter( 'teach_kiddo_pro_filter_about_section_details', 'teach_kiddo_pro_get_about_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_about_section' ) ) :
  /**
   * Start about section
   *
   * @return string about content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_about_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_about_section">

        <?php foreach ( $content_details as $content ) : ?>
        <div id="about-us" class="relative page-section">
            <div class="wrapper">
             <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'about-us' );
                endif; ?>
                <div class="col-2">
                    <article>
                        <div class="about-item-wrapper">
                            <?php if ( !empty( $options['about_featured_image'] ) ): ?>
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $options['about_featured_image'] ); ?>');"></div>
                            <?php endif ?>

                            <div class="video">
                                <header class="entry-header">
                                    <?php if ( !empty( $options['about_video_intro_text'] ) ): ?>
                                        <h2 class="entry-title"><?php echo teach_kiddo_pro_santize_allow_tag( $options['about_video_intro_text'] ); ?></h2>
                                    <?php endif;
                                    if ( !empty( $options['about_video_sub_intro_text'] ) ): ?>
                                        <p><?php echo teach_kiddo_pro_santize_allow_tag( $options['about_video_sub_intro_text'] ); ?></p>
                                    <?php endif ?>

                                </header>

                                <?php if ( !empty( $options['about_video_image'] ) ): ?>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $options['about_video_image'] ); ?>');">
                                        <?php if ( !empty( $options['about_video_link'] ) ): ?>
                                            <div class="video-button">
                                                <a href="<?php echo esc_url( $options['about_video_link'] ) ?>" class="popup-youtube" title="<?php echo esc_attr__( 'youtube-video', 'teach-kiddo-pro' ) ; ?>">
                                                    <svg viewBox="0 0 41.999 41.999">
                                                        <path d="M36.068,20.176l-29-20C6.761-0.035,6.363-0.057,6.035,0.114C5.706,0.287,5.5,0.627,5.5,0.999v40
                                                        c0,0.372,0.206,0.713,0.535,0.886c0.146,0.076,0.306,0.114,0.465,0.114c0.199,0,0.397-0.06,0.568-0.177l29-20
                                                        c0.271-0.187,0.432-0.494,0.432-0.823S36.338,20.363,36.068,20.176z M7.5,39.095V2.904l26.239,18.096L7.5,39.095z"/>
                                                    </svg>
                                                </a>
                                            </div>
                                        <?php endif;?>

                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </article>

                    <article class="has-post-thumbnail">
                        <div class="about-wrapper">
                            <div class="entry-container">
                                <div class="section-header">
                                    <?php if ( !empty( $options['about_sub_title'] ) ): ?>
                                        <p class="section-subtitle"><?php echo esc_html($options['about_sub_title']); ?></p>
                                    <?php endif ?>

                                    <h2 class="section-title"><a href="<?php echo esc_url( $content['url'] ); ?>" title="<?php echo esc_attr( $content['title'] ); ?>" ><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </div><!-- .section-header -->

                                <div class="entry-content">
                                    <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                </div><!-- .entry-content -->

                                <?php if ( !empty( $options['about_btn_text'] ) ): ?>
                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo esc_html( $options['about_btn_text'] ) ; ?></a>
                                    </div><!-- .read-more -->
                                <?php endif ?>

                            </div><!-- .entry-container -->

                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');"></div>
                        </div>
                    </article>
                </div><!-- .col-2 -->
            </div><!-- .wrapper -->
        </div><!-- #about-section -->
        <?php endforeach; ?>

        </div>
        
        <?php 
    }
endif;