<?php
/**
 * Blog section
 *
 * This is the template for the content of blog section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_blog_section' ) ) :
    /**
    * Add blog section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_blog_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if blog is enabled on frontpage
        $blog_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'blog_section_enable' );

        if ( true !== $blog_enable ) {
            return false;
        }
        // Get blog section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

         teach_kiddo_pro_render_blog_section( $section_details );

    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_blog_section_details' ) ) :
    /**
    * blog section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input blog section details.
    */
    function teach_kiddo_pro_get_blog_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $blog_content_type  = $options['blog_content_type'];    
        $blog_count = ! empty( $options['blog_count'] ) ? $options['blog_count'] : 4;
        
        $content = array();
        switch ( $blog_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_page_' . $i] ) )
                        $page_ids[] = $options['blog_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_post_' . $i] ) )
                        $post_ids[] = $options['blog_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['blog_content_category'] ) ? $options['blog_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $blog_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['blog_excerpt_length'] );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;

        wp_reset_postdata();
    
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'teach_kiddo_pro_filter_blog_section_details', 'teach_kiddo_pro_get_blog_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_blog_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_blog_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_blog_section">

        <div id="latest-posts" class="relative page-section">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-18.png' ?>" class="layer layer-18" alt="layer-18">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-19.png' ?>" class="layer layer-19" alt="layer-19">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-20.png' ?>" class="layer layer-20" alt="layer-20">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-21.png' ?>" class="layer layer-21" alt="layer-21">
            <div class="wrapper">
            <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'latest-posts' );
                endif; ?>
                <div class="section-header">
                   <?php if ( !empty( $options['blog_title'] ) ): ?>
                        <h2 class="section-title">
                            <span><?php echo esc_html( $options['blog_title'] ); ?></span>                            
                            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                        </h2>
                    <?php endif; ?>                             
                </div><!-- .section-header -->                  

                <div class="archive-blog-wrapper col-3 clear">
                    <?php $i=1; foreach ( $content_details as $content ): ?>
                        <article>
                            <div class="post-item">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] );?>');"></div>

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span>

                                        <?php teach_kiddo_pro_posted_on( $content['id'] ) ; ?>
                                    </div>
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] );?>" title="<?php echo esc_attr( $content['title'] );?>"><?php echo esc_html( $content['title'] );?></a></h2>
                                    </header>
                                    
                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] );?>" class="btn"><?php echo __( 'Read More', 'teach-kiddo-pro' ) ?></a>
                                    </div><!-- .read-more -->
                                </div><!-- .entry-container -->
                            </div><!-- .post-wrapper -->
                        </article>                            
                    <?php $i++; endforeach; ?>        
                </div><!-- .archive-blog-wrapper -->
                <?php if ( !empty( $options['blog_btn_title'] ) && !empty( $options['blog_btn_url'] ) ): ?>
                    <div class="read-more">
                        <a href="<?php echo esc_url( $options['blog_btn_url'] ) ; ?>" class="btn"><?php echo esc_html( $options['blog_btn_title'] ) ; ?></a>
                    </div>
                <?php endif ?>
            </div><!-- .wrapper -->
        </div><!-- #latest-posts-section -->
    </div>

    <?php }
endif;