<?php
/**
 * Client section
 *
 * This is the template for the content of client section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_client_section' ) ) :
    /**
    * Add client section
    *
    *@since teach_kiddo_pro 1.0.0
    */
    function teach_kiddo_pro_add_client_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if client is enabled on frontpage
        $client_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'client_section_enable' );

        if ( true !== $client_enable ) {
            return false;
        }
        // Get client section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_client_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render client section now.
        teach_kiddo_pro_render_client_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_client_section_details' ) ) :
    /**
    * client section details.
    *
    * @since teach_kiddo_pro 1.0.0
    * @param array $input client section details.
    */
    function teach_kiddo_pro_get_client_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $client_content_type  = $options['client_content_type'];
        $client_count = ! empty( $options['client_count'] ) ? $options['client_count'] : 6;
        
        $content = array();
        switch ( $client_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $client_count; $i++ ) {
                    if ( ! empty( $options['client_content_page_' . $i] ) )
                        $page_ids[] = $options['client_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $client_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $client_count; $i++ ) {
                    if ( ! empty( $options['client_content_post_' . $i] ) )
                        $post_ids[] = $options['client_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $client_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['client_content_category'] ) ? $options['client_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $client_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i=1; $i <= $client_count; $i++ ) { 
                    $custom['image']    = ( empty( $options['client_image_' . $i ] ) ) ? '' : $options['client_image_' . $i ];                
                    $custom['url']      = ( empty( $options['client_url_' . $i ] ) ) ? '' : $options['client_url_' . $i ];                         
                    array_push( $content, $custom );
                }
            break;

            default:
            break;
        }

        // Run The Loop.
        if ( 'custom' !== $options['client_content_type'] ) {
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['url']       = get_the_permalink( );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';
                    // Push to the main array.
                    array_push( $content, $page_post );

                endwhile;
            endif;
            wp_reset_postdata();
        }
                    
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// client section content details.
add_filter( 'teach_kiddo_pro_filter_client_section_details', 'teach_kiddo_pro_get_client_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_client_section' ) ) :
  /**
   * Start client section
   *
   * @return string client content
   * @since teach_kiddo_pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_client_section( $content_details = array() ) {
        $options    = teach_kiddo_pro_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_client_section">
            <div id="sponsor-section" class="relative page-section">
                <div class="wrapper">
                     <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'sponsor-section' );
                    endif; ?>
                    <div class="section-content col-5 clear">
                        <?php $i = 1 ; foreach ( $content_details as $content ): ?>
                            <article>
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" target="_blank"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="sponsor"></a>
                                </div><!-- .featured-image -->
                            </article>
                        <?php $i++; endforeach ?>
                    </div><!-- .col-5 -->                        
                </div><!-- .wrapper -->
            </div><!-- #sponsor-section -->
        </div>
        
    <?php }
endif;