<?php
/**
 * contact section
 *
 * This is the template for the content of contact section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_contact_section' ) ) :
    /**
    * Add contact section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_contact_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if contact is enabled on frontpage
        $contact_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'contact_section_enable' );

        if ( true !== $contact_enable ) {
            return false;
        }

        // Render contact section now.
        teach_kiddo_pro_render_contact_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_contact_section' ) ) :
  /**
   * Start contact section
   *
   * @return string contact content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_contact_section() {
        $options = teach_kiddo_pro_get_theme_options();
        $image   = empty( $options['contact_image'] ) ? '' : $options['contact_image'] ;
        $contents = array();
        for( $i= 1; $i <=4 ; $i++ ){
            $page_post['icon']      = empty( $options['contact_content_icon_'.$i] ) ? '' : $options['contact_content_icon_'.$i] ;
            $page_post['title']     = empty( $options['contact_title_'.$i] ) ? '' :$options['contact_title_'.$i];
            $page_post['number']    = empty( $options['contact_number_'.$i] ) ? '' :$options['contact_number_'.$i];
            array_push( $contents, $page_post );
        }
       
        ?>

        <div id="teach_kiddo_pro_contact_section">
            
            <div id="contact-section" class="relative page-section same-background">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-22.png' ?>" class="layer layer-22" alt="layer-22">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-23.png' ?>" class="layer layer-23" alt="layer-23">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-24.png' ?>" class="layer layer-24" alt="layer-24">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-25.png' ?>" class="layer layer-25" alt="layer-25">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        teach_kiddo_pro_section_tooltip( 'contact-section' );
                    endif; ?>
                    <div class="contact-section-wrapper clear">
                        <div class="section-header-wrapper">
                            <?php if ( !empty( $options['contact_title_1'] ) ): ?>
                                <div class="section-header">
                                    <h2 class="section-title"><?php echo esc_html( $options['contact_title_1'] ) ?></h2>
                                </div><!-- .section-header -->
                            <?php endif ?>                            

                            <div class="contact-information">
                                <ul>
                                    <li>
                                        <?php if ( !empty( $options['contact_phone_icon'] ) ): ?>
                                            <i class="fa <?php echo esc_attr( $options['contact_phone_icon'] ); ?>"></i>
                                        <?php endif ?>
                                        <?php if ( !empty( $options['contact_phone_label'] ) ): ?>
                                            <span><?php echo esc_html( $options['contact_phone_label'] ); ?></span>
                                        <?php endif ?>
                                        <?php if ( !empty( $options['contact_phone_number'] ) ): ?>
                                            <?php echo esc_html( $options['contact_phone_number'] ); ?>
                                        <?php endif ?>
                                    </li>
                                    <li>
                                        <?php if ( !empty( $options['contact_email_icon'] ) ): ?>
                                            <i class="fa <?php echo esc_attr( $options['contact_email_icon'] ); ?>"></i>
                                        <?php endif ?>
                                         <?php if ( !empty( $options['contact_email_label'] ) ): ?>
                                            <span><?php echo esc_html( $options['contact_email_label'] ); ?></span>
                                        <?php endif ?>
                                        <?php if ( !empty( $options['contact_email_text'] ) ): ?>
                                            <?php echo esc_html( $options['contact_email_text'] ); ?>
                                        <?php endif ?>
                                    </li>
                                    <li>
                                        <?php if ( !empty( $options['contact_location_icon'] ) ): ?>
                                            <i class="fa <?php echo esc_attr( $options['contact_location_icon'] ); ?>"></i>
                                        <?php endif ?>
                                         <?php if ( !empty( $options['contact_location_label'] ) ): ?>
                                            <span><?php echo esc_html( $options['contact_location_label'] ); ?></span>
                                        <?php endif ?>
                                        <?php if ( !empty( $options['contact_location_text'] ) ): ?>
                                            <?php echo esc_html( $options['contact_location_text'] ); ?>
                                        <?php endif ?>
                                    </li>
                                </ul>
                            </div><!-- .contact-information -->
                        </div><!-- .section-header-wrapper -->

                        <div class="section-content">
                            <?php if ( !empty( $options['contact_title_2'] ) ): ?>
                                <div class="section-header">
                                    <h2 class="section-title"><?php echo esc_html( $options['contact_title_2'] ) ?></h2>
                                </div><!-- .section-header -->
                            <?php endif ?>

                            <?php echo do_shortcode( $options['contact_form_shortcode'] ); ?>
                        </div><!-- .section-content -->
                    </div><!-- .contact-section-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- #contact-section -->
        </div>

    <?php }
endif;