<?php
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_counter_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if counter is enabled on frontpage
        $counter_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'counter_section_enable' );

        if ( true !== $counter_enable ) {
            return false;
        }

        // Render counter section now.
        teach_kiddo_pro_render_counter_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_counter_section' ) ) :
  /**
   * Start counter section
   *
   * @return string counter content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_counter_section() {
        $options = teach_kiddo_pro_get_theme_options();
        $image   = empty( $options['counter_image'] ) ? '' : $options['counter_image'] ;
        $contents = array();
        for( $i= 1; $i <= 4 ; $i++ ){
            $page_post['icon']      = empty( $options['counter_content_icon_'.$i] ) ? '' : $options['counter_content_icon_'.$i] ;
            $page_post['title']     = empty( $options['counter_title_'.$i] ) ? '' :$options['counter_title_'.$i];
            $page_post['number']    = empty( $options['counter_number_'.$i] ) ? '' :$options['counter_number_'.$i];
            array_push( $contents, $page_post );
        }
       

        ?>

        <div id="teach_kiddo_pro_counter_section">
            
            <div id="counter-section" class="relative page-section" style="background-image: url('<?php echo esc_url( $image ) ; ?>');">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-10.png' ?>" class="layer layer-10" alt="layer-10">
                <div class="wrapper">
                <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'counter-section' );
                endif; ?>
                    <div class="section-content <?php echo esc_attr( $options['counter_column'] ); ?> clear">
                        
                        <?php foreach ( $contents as $content ): ?>

                        <article>
                            <div class="counter-item">
                            <?php if( !empty( $content['icon'] ) ): ?>
                                <div class="counter-icon">
                                    <i class="fa <?php echo esc_attr( $content['icon'] ) ; ?>"></i>
                                </div>
                            <?php endif;
                                if( !empty( $content['number'] ) ):
                             ?>
                                <h2 class="counter-value"><?php echo esc_html( $content['number'] ); ?></h2>
                            <?php endif;
                                if( !empty( $content['title'] ) ):
                             ?>
                                <h3 class="counter-title"><?php echo esc_html( $content['title'] ); ?></h3>
                            <?php endif; ?>
                            </div><!-- .counter-item -->
                        </article>

                    <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #counter-section -->

            </div>

    <?php }
endif;