<?php
/**
 * featured_course section
 *
 * This is the template for the content of featured_course section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_featured_course_section' ) ) :
    /**
    * Add featured_course section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_featured_course_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if featured_course is enabled on frontpage
        $featured_course_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'featured_course_section_enable' );

        if ( true !== $featured_course_enable ) {
            return false;
        }
        // Get featured_course section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_featured_course_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render featured_course section now.
        teach_kiddo_pro_render_featured_course_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_featured_course_section_details' ) ) :
    /**
    * featured_course section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input featured_course section details.
    */
    function teach_kiddo_pro_get_featured_course_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $featured_course_content_type  = $options['featured_course_content_type'];
        $featured_course_count = ! empty( $options['featured_course_count'] ) ? $options['featured_course_count'] : 3;

        $content = array();
        switch ( $featured_course_content_type ) {
            
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $featured_course_count; $i++ ) {
                    if ( ! empty( $options['featured_course_content_page_' . $i] ) ) :
                        $page_ids[] = $options['featured_course_content_page_' . $i];
                        $position[] = ! empty( $options['featured_course_position_' . $i] ) ? $options['featured_course_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $featured_course_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $featured_course_count; $i++ ) {
                    if ( ! empty( $options['featured_course_content_post_' . $i] ) ) :
                        $post_ids[] = $options['featured_course_content_post_' . $i];
                        $position[] = ! empty( $options['featured_course_position_' . $i] ) ? $options['featured_course_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $featured_course_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['featured_course_content_category'] ) ? $options['featured_course_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $featured_course_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'course':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $course_ids = array();

                for ( $i = 1; $i <= $featured_course_count; $i++ ) {
                    if ( ! empty( $options['featured_course_content_course_' . $i] ) ) :
                        $course_ids[] = $options['featured_course_content_course_' . $i];
                    endif;
                }

               $args = array(
                    'post_type'         => 'tp-course',
                    'post__in'          => ( array ) $course_ids,
                    'posts_per_page'    => absint( $featured_course_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    ); 

            break;

            case 'course-category':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $cat_id = ! empty( $options['featured_course_content_course_category'] ) ? $options['featured_course_content_course_category'] : '';

                $args = array(
                    'post_type'         => 'tp-course',
                    'posts_per_page'    => absint( $featured_course_count ),
                    'tax_query'         => array(  
                        array( 
                            'taxonomy'  => 'tp-course-category', 
                            'field'     => 'id', 
                            'terms'     => array( $cat_id ),  
                            ) 
                        ),
                    );                    
            break;
            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        $i = 0;
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['position']  = !empty( $position[$i] ) ? $position[$i] : '';
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['featured_course_excerpt_length'] );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
                $i++;
            endwhile;
        endif;
        wp_reset_postdata();
        
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured_course section content details.
add_filter( 'teach_kiddo_pro_filter_featured_course_section_details', 'teach_kiddo_pro_get_featured_course_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_featured_course_section' ) ) :
  /**
   * Start featured_course section
   *
   * @return string featured_course content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_featured_course_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();
        $featured_course_content_type  = $options['featured_course_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_featured_course_section">
             <div id="featured-courses" class="relative page-section">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-7.png' ?>" class="layer layer-7" alt="layer-7">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-26.png' ?>" class="layer layer-26" alt="layer-26">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-27.png' ?>" class="layer layer-27" alt="layer-27">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-28.png' ?>" class="layer layer-28" alt="layer-28">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-29.png' ?>" class="layer layer-29" alt="layer-29">
                <div class="wrapper">
                    <?php if ( $options['featured_course_title'] ): ?>
                        <div class="section-header">
                            <h2 class="section-title">
                                <span><?php echo esc_html( $options['featured_course_title'] ) ; ?></span>
                                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                            </h2>
                        </div>                        
                    <?php endif; ?>

                    <div class="featured-course-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": false, "speed": 800, "dots": false, "arrows": true, "autoplay": false, "draggable": true, "fade": false }'>
                        <?php foreach ( $content_details as $content ): ?>
                            <article>
                                <div class="featured-course-item">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ) ?>');"><a href="<?php echo esc_url( $content['url'] ) ?>" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ?>"><?php echo esc_html( $content['title'] ) ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo esc_html( $content['excerpt'] ) ?></p>
                                        </div><!-- .entry-content -->

                                        <div class="read-more">
                                            <a href="<?php echo esc_url( $content['url'] ) ?>" class="btn"><?php echo esc_html( $options['featured_course_read_more'] ); ?></a>
                                        </div><!-- .read-more -->
                                    </div><!-- .entry-container -->
                                </div><!-- .featured-course-item -->
                                <?php if ( $featured_course_content_type == 'course' || $featured_course_content_type == 'course-category' ): ?>
                                    <div class="featured-course-meta">
                                        <div class="estimated-time">
                                            <?php if ( ! empty( $options['featured_estemate_label'] ) ): ?>
                                                <h3><?php echo esc_html( $options['featured_estemate_label'] ); ?></h3>
                                            <?php endif ?>
                                            <?php tp_course_duration( $content['id'] ); ?>                                      

                                        </div><!-- .estimated-time -->

                                        <div class="enroll-by">
                                            <?php if ( ! empty( $options['featured_starts_on_label'] ) ): ?>
                                                <h3><?php echo esc_html( $options['featured_starts_on_label'] ); ?></h3>
                                            <?php endif ?>  
                                            <?php tp_course_starting_date( $content['id'] ); ?>     
                                        </div><!-- .enroll-by -->

                                        <?php if ( function_exists( 'rmp_get_visual_rating' ) ): ?>
                                            <div class="course-rating">
                                                <?php if ( ! empty( $options['featured_rating_label'] ) ): ?>
                                                    <h3><?php echo esc_html( $options['featured_rating_label'] ); ?></h3>
                                                <?php endif ?>  
                                                <?php echo rmp_get_visual_rating($content['id']); ?>
                                            </div><!-- .course-rating -->
                                        <?php endif ?>
                                        
                                    </div><!-- .featured-course-meta -->
                                <?php endif ?>
                               
                            </article>
                        <?php endforeach ?>
                    </div><!-- .featured-course-slider -->
                </div><!-- .wrapper -->
            </div><!-- #featured-courses -->
    <?php }
endif;