<?php
/**
 * Featured Posts section
 *
 * This is the template for the content of blog section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_featured_posts_section' ) ) :
    /**
    * Add Featured Posts section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_featured_posts_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if Featured Posts is enabled on frontpage
        $featured_posts_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'featured_posts_section_enable' );

        if ( true !== $featured_posts_enable ) {
            return false;
        }
        // Get Featured Posts section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_featured_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }


        teach_kiddo_pro_render_featured_posts_section( $section_details );


    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_featured_posts_section_details' ) ) :
    /**
    * Featured Posts section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input Featured Posts section details.
    */
    function teach_kiddo_pro_get_featured_posts_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $featured_posts_content_type  = $options['featured_posts_content_type'];
        $featured_posts_count = ! empty( $options['featured_posts_count'] ) ? $options['featured_posts_count'] : 3;
        
        $content = array();
        switch ( $featured_posts_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $featured_posts_count; $i++ ) {
                    if ( ! empty( $options['featured_posts_content_page_' . $i] ) )
                        $page_ids[] = $options['featured_posts_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $featured_posts_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $featured_posts_count; $i++ ) {
                    if ( ! empty( $options['featured_posts_content_post_' . $i] ) )
                        $post_ids[] = $options['featured_posts_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $featured_posts_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['featured_posts_content_category'] ) ? $options['featured_posts_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $featured_posts_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'teach_kiddo_pro_filter_featured_posts_section_details', 'teach_kiddo_pro_get_featured_posts_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_featured_posts_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_featured_posts_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
       
       <div id="teach_kiddo_pro_featured_posts_section">

        <div id="featured-posts-section" class="relative page-section same-background">
                <div class="wrapper">
                <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'featured-posts-section' );
                endif; ?> 
                    <div class="section-contnet <?php echo esc_attr( $options['featured_posts_col_layout'] ); ?> clear">
                       <?php foreach ( $content_details as $content ): ?>

                        <article>
                            <div class="featured-post-item">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ) ; ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="post-thumbnail-link"></a>
                                </div><!-- .blog-featured-item -->
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                </header>
                            </div>                           
                        </article>

                    <?php endforeach; ?>

                    </div><!-- .blog-section-content -->
                </div><!-- .wrapper -->
            </div><!-- #blog-featured-posts -->

            </div>

    <?php }
endif;