<?php
/**
 * featured_products section
 *
 * This is the template for the content of featured_products section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_featured_products_section' ) ) :
    /**
    * Add featured_products section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_featured_products_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if featured_products is enabled on frontpage
        $featured_products_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'featured_products_section_enable' );

        if ( ( true !== $featured_products_enable ) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }
        // Get featured_products section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_featured_products_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render featured_products section now.
        teach_kiddo_pro_render_featured_products_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_featured_products_section_details' ) ) :
    /**
    * featured_products section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input featured_products section details.
    */
    function teach_kiddo_pro_get_featured_products_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $featured_products_content_type  = $options['featured_products_content_type'];    
        $featured_products_count = !empty( $options['featured_products_count'] ) ? $options['featured_products_count'] : 3;
        
        $content = array();
        $content = array();
        switch ( $featured_products_content_type ) {

            case 'product':
                $page_ids = array();

                for ( $i = 1; $i <= $featured_products_count; $i++ ) {
                    if ( ! empty( $options['featured_products_content_product_' . $i] ) )
                        $page_ids[] = $options['featured_products_content_product_' . $i];
                }

                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $featured_products_count ),
                    'orderby'           => 'post__in',
                    );
            break;
            case 'product-category':
                $cat_id = ! empty( $options['featured_products_content_product_category'] ) ? $options['featured_products_content_product_category'] : '';

                $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => absint( $featured_products_count ),
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'id',
                        'terms'     => $cat_id
                    )
                ) );
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
   
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured_products section content details.
add_filter( 'teach_kiddo_pro_filter_featured_products_section_details', 'teach_kiddo_pro_get_featured_products_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_featured_products_section' ) ) :
  /**
   * Start featured_products section
   *
   * @return string featured_products content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_featured_products_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_featured_products_section">
            <div id="featured-products" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        teach_kiddo_pro_section_tooltip( 'featured-products' );
                    endif; ?>
                    <div class="section-content clear col-2">
                        <?php $i=1; foreach ( $content_details as $content ): 
                            $image = $content['image'] == '' ? get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg' : $content['image'] ;
                        ?>        
                            <article>
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $image ); ?>');">
                                    <div class="entry-container">
                                        <span class="cat-links">
                                            <ul class="post-categories">
                                                <?php 
                                                    $terms = get_the_terms ( $content['id'], 'product_cat' );
                                                    foreach ( $terms as $term ) { 
                                                ?>
                                                    <li>
                                                        <a href="<?php echo esc_url( get_term_link( $term->term_id, 'product_cat' ) ) ?>"><?php echo esc_html( $term->name) ; ?></a>
                                                    </li>
                                                <?php } ?>                                               
                                            </ul>
                                        </span>

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <?php if ( !empty( $options['featured_products_sub_title_'.$i] ) ): ?>
                                            <div class="entry-content">
                                                <p><?php echo esc_html( $options['featured_products_sub_title_'.$i] ); ?></p>
                                            </div><!-- .entry-content -->
                                        <?php endif ?>                                       
                                        <?php if (!empty( $options['featured_products_btn_label'] ) ): ?>
                                            <div class="read-more">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo  esc_html( $options['featured_products_btn_label'] ); ?></a>
                                            </div><!-- .read-more -->
                                        <?php endif ?>
                                        
                                    </div><!-- .entry-container -->
                                </div><!-- .featured-image -->
                            </article>
                        <?php $i++; endforeach; ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #featured-products -->
        </div>

    <?php }
endif;