<?php
/**
 * gallery section
 *
 * This is the template for the content of gallery section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_gallery_section' ) ) :
    /**
    * Add gallery section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_gallery_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if gallery is enabled on frontpage
        $gallery_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'gallery_section_enable' );

        if ( true !== $gallery_enable ) {
            return false;
        }

        // Get gallery section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_gallery_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }


        teach_kiddo_pro_render_gallery_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_gallery_section_details' ) ) :
    /**
    * gallery section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input gallery section details.
    */
    function teach_kiddo_pro_get_gallery_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $gallery_content_type  = $options['gallery_content_type'];
        $gallery_count = ! empty( $options['gallery_count'] ) ? $options['gallery_count'] : 4;
        
        $content = array();
        switch ( $gallery_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $gallery_count; $i++ ) {
                    if ( ! empty( $options['gallery_content_page_' . $i] ) )
                        $page_ids[] = $options['gallery_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $gallery_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $gallery_count; $i++ ) {
                    if ( ! empty( $options['gallery_content_post_' . $i] ) )
                        $post_ids[] = $options['gallery_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $gallery_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['gallery_content_category'] ) ? $options['gallery_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $gallery_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['author_id'] = get_post_field('post_author', get_the_ID());
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// gallery section content details.
add_filter( 'teach_kiddo_pro_filter_gallery_section_details', 'teach_kiddo_pro_get_gallery_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_gallery_section' ) ) :
  /**
   * Start gallery section
   *
   * @return string gallery content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_gallery_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_gallery_section">

        <div id="gallery-section" class="relative page-section same-background">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-8.png' ?>" class="layer layer-8" alt="layer-8">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-9.png' ?>" class="layer layer-9" alt="layer-9">
            <div class="wrapper">
            <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'gallery-section' );
                endif; ?>
                <div class="section-header">
                    <?php if ( !empty( $options['gallery_title'] ) ): ?>
                        <h2 class="section-title">
                            <span><?php echo esc_html( $options['gallery_title'] ); ?></span>                            
                            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                        </h2>
                    <?php endif; ?>
                </div><!-- .section-header -->
            </div><!-- .wrapper -->
            <div class="section-content col-4 clear" >
                <?php foreach ( $content_details as $content ): ?>
                    <article>
                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ) ; ?>');">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                            </header>
                        </div><!-- .featured-image -->
                    </article>
                <?php endforeach ?>    
            </div><!-- .col-4 -->
            
            <?php if ( !empty( $options['gallery_btn_title'] ) ): ?>
                <div class="read-more">
                    <a href="<?php echo esc_url( $options['gallery_btn_url'] ); ?>" class="btn"><?php echo esc_html( $options['gallery_btn_title'] ); ?></a>
                </div><!-- .read-more -->
            <?php endif ?>
            
        </div><!-- #gallery-section -->

    </div>
      
    <?php }
endif;