<?php
/**
 * Instagram section
 *
 * This is the template for the content of instagram section
 *
 * @package Theme Palace
 * @subpackage Fondness Pro
 * @since Fondness Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_instagram_section' ) ) :
    /**
    * Add instagram section
    *
    *@since Fondness Pro 1.0.0
    */
    function teach_kiddo_pro_add_instagram_section() {
      $options = teach_kiddo_pro_get_theme_options();
        // Check if instagram is enabled on frontpage
        $instagram_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'instagram_section_enable' );

        if ( true !== $instagram_enable ) {
            return false;
        }

        // Render instagram section now.
        teach_kiddo_pro_render_instagram_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_instagram_section' ) ) :
  /**
   * Start instagram section
   *
   * @return string instagram content
   * @since Fondness Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_instagram_section() {
    $options = teach_kiddo_pro_get_theme_options();
    ?>

    <div id="teach_kiddo_pro_instagram_section">
      <div id="instagram-section" class="relative page-section same-background">
            <div class="wrapper">
               <?php if ( is_customize_preview()): ?>
                    <?php teach_kiddo_pro_section_tooltip( 'instagram-section' ); ?>
                <?php endif ?>
                 <?php if ( $options['instagram_title'] ): ?>
                    <div class="section-header">
                        <h2 class="section-title">
                            <span><?php echo esc_html( $options['instagram_title'] ) ; ?></span>
                            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                        </h2>
                     </div><!-- .section-header -->
                <?php endif; ?>   
                <div class="col-6 clear">
                  <?php echo do_shortcode( '[instagram-feed num=6 cols=6 showheader=false showbutton=false showfollow=false]' ); ?>
                </div><!-- .col-6 -->
            </div><!-- .wrapper -->
        </div><!-- #instagram-section -->
    </div>
        

    <?php }
endif;

