<?php
/**
 * latest_products section
 *
 * This is the template for the content of latest_products section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_latest_products_section' ) ) :
    /**
    * Add latest_products section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_latest_products_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if latest_products is enabled on frontpage
        $latest_products_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'latest_products_section_enable' );

        if ( ( true !== $latest_products_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render latest_products section now.
        teach_kiddo_pro_render_latest_products_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_latest_products_section' ) ) :
  /**
   * Start latest_products section
   *
   * @return string latest_products content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_latest_products_section() {
        $options = teach_kiddo_pro_get_theme_options();

    ?>

    <div id="teach_kiddo_pro_latest_products_section">
         <div id="latest-products" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'latest-products' );
                endif; ?>
                <div class="col-2 clear">
                    <?php for ( $i=1; $i <= $options['latest_products_count']; $i++ ) { 
                        if ( empty($options['latest_products_content_latest_products_category_'.$i]) ) {
                            continue;
                    }
                    $thumbnail_id = get_term_meta( $options['latest_products_content_latest_products_category_'.$i], 'thumbnail_id', true );
                    $image = !empty( wp_get_attachment_url( $thumbnail_id ) ) ? wp_get_attachment_url( $thumbnail_id ) : get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                    $cat_name = get_term_by( 'id', $options['latest_products_content_latest_products_category_'.$i], 'product_cat' )->name;
                    $cat_link = get_category_link( $options['latest_products_content_latest_products_category_'.$i] );
                    ?>
                        <article>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $image ); ?>');">
                                <div class="entry-container">
                                    <header class="entry-header">
                                         <h2 class="entry-title"><a href="<?php echo esc_url( $cat_link ) ?>"><?php echo esc_html( $cat_name ); ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </div><!-- .featured-image -->
                        </article>
                    <?php } ?>

                </div><!-- .grid --> 
            </div><!-- .wrapper -->
        </div><!-- #latest-products -->
    </div>

    <?php }
endif;