<?php
/**
 * popular_course section
 *
 * This is the template for the content of popular_course section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_popular_course_section' ) ) :
    /**
    * Add popular_course section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_popular_course_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if popular_course is enabled on frontpage
        $popular_course_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'popular_course_section_enable' );

        if ( true !== $popular_course_enable ) {
            return false;
        }
        // Get popular_course section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_popular_course_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render popular_course section now.
        teach_kiddo_pro_render_popular_course_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_popular_course_section_details' ) ) :
    /**
    * popular_course section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input popular_course section details.
    */
    function teach_kiddo_pro_get_popular_course_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $popular_course_content_type  = $options['popular_course_content_type'];
        $popular_course_count = ! empty( $options['popular_course_count'] ) ? $options['popular_course_count'] : 3;

        $content = array();
        switch ( $popular_course_content_type ) {
            
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $popular_course_count; $i++ ) {
                    if ( ! empty( $options['popular_course_content_page_' . $i] ) ) :
                        $page_ids[] = $options['popular_course_content_page_' . $i];
                        $position[] = ! empty( $options['popular_course_position_' . $i] ) ? $options['popular_course_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_course_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $popular_course_count; $i++ ) {
                    if ( ! empty( $options['popular_course_content_post_' . $i] ) ) :
                        $post_ids[] = $options['popular_course_content_post_' . $i];
                        $position[] = ! empty( $options['popular_course_position_' . $i] ) ? $options['popular_course_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $popular_course_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['popular_course_content_category'] ) ? $options['popular_course_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $popular_course_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'course':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $course_ids = array();

                for ( $i = 1; $i <= $popular_course_count; $i++ ) {
                    if ( ! empty( $options['popular_course_content_course_' . $i] ) ) :
                        $course_ids[] = $options['popular_course_content_course_' . $i];
                    endif;
                }

               $args = array(
                    'post_type'         => 'tp-course',
                    'post__in'          => ( array ) $course_ids,
                    'posts_per_page'    => absint( $popular_course_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    ); 

            break;

            case 'course-category':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $cat_id = ! empty( $options['popular_course_content_course_category'] ) ? $options['popular_course_content_course_category'] : '';

                $args = array(
                    'post_type'         => 'tp-course',
                    'posts_per_page'    => absint( $popular_course_count ),
                    'tax_query'         => array(  
                        array( 
                            'taxonomy'  => 'tp-course-category', 
                            'field'     => 'id', 
                            'terms'     => array( $cat_id ),  
                            ) 
                        ),
                    );                    
            break;
            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        $i = 0;
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['position']  = !empty( $position[$i] ) ? $position[$i] : '';
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
                $i++;
            endwhile;
        endif;
        wp_reset_postdata();
        
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// popular_course section content details.
add_filter( 'teach_kiddo_pro_filter_popular_course_section_details', 'teach_kiddo_pro_get_popular_course_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_popular_course_section' ) ) :
  /**
   * Start popular_course section
   *
   * @return string popular_course content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_popular_course_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();
        $popular_course_content_type  = $options['popular_course_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_popular_course_section">

            <div id="popular-courses" class="relative page-section">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-11.png' ?>" class="layer layer-11" alt="layer-11">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-12.png' ?>" class="layer layer-12" alt="layer-12">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-13.png' ?>" class="layer layer-13" alt="layer-13">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-14.png' ?>" class="layer layer-14" alt="layer-14">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        teach_kiddo_pro_section_tooltip( 'popular-courses' );
                    endif; ?>
                    <?php if ( $options['popular_course_title'] ): ?>
                        <div class="section-header">
                            <h2 class="section-title">
                                <span><?php echo esc_html( $options['popular_course_title'] ) ; ?></span>
                                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                            </h2>
                        </div>                        
                    <?php endif; ?>

                    <div class="section-content col-3 clear">
                        <?php foreach ( $content_details as $content ): ?>
                            <article>
                                <div class="popular-course-item">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ) ?>');">
                                        <a href="<?php echo esc_url( $content['url'] ) ?>" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <div class="entry-meta">
                                            <?php if ( $options['popular_course_content_type'] == 'course' || $options['popular_course_content_type'] == 'course-category' ): ?>
                                                <span class="cat-links">
                                                    <?php foreach ( get_the_terms($content['id'], 'tp-course-category' ) as $cat): ?>
                                                        <ul class="post-categories">
                                                            <li><a href="<?php echo esc_url( get_category_link( $cat->term_id ) ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
                                                        </ul>                     
                                                    <?php endforeach ?>                              
                                                </span><!-- .cat-links -->
                                                <?php else: ?>
                                                    <span class="cat-links">
                                                        <?php foreach ( get_the_category($content['id']) as $cat): ?>
                                                            <ul class="post-categories">
                                                                <li><a href="<?php echo esc_url( get_category_link( $cat->term_id ) ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
                                                            </ul>                     
                                                        <?php endforeach ?>                              
                                                    </span><!-- .cat-links -->
                                            <?php endif ?>
                            

                                            <?php if ( $popular_course_content_type == 'course' || $popular_course_content_type == 'course-category' ): ?>
                                                <span class="total-students"><?php tp_course_students( $content['id'] ); ?> <?php echo __( 'students', 'teach-kiddo-pro' ) ?></span>
                                            <?php endif ?>
                                            
                                        </div><!-- .entry-meta -->

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ?>"><?php echo esc_html( $content['title'] ) ?></a></h2>
                                        </header>

                                        <div class="footer-meta">

                                            <?php if ( $popular_course_content_type == 'course' || $popular_course_content_type == 'course-category' ): ?>
                                                <span class="course-price">
                                                    <ins><?php tp_course_price( $content['id'] ); ?></ins> <?php tp_course_duration( $content['id'] ); ?>
                                                </span><!-- .course-price -->
                                            <?php endif ?>
                                            

                                            <?php if ( !empty( $options['popular_course_read_more'] ) ): ?>
                                                <div class="read-more">
                                                    <a href="<?php echo esc_url( $content['url'] ) ?>" class="btn"><?php echo esc_html( $options['popular_course_read_more'] ); ?></a>
                                                </div><!-- .read-more -->
                                            <?php endif ?>
                                            
                                        </div><!-- .footer-meta -->
                                    </div><!-- .entry-container -->
                                </div><!-- .popular-course-item -->
                            </article>
                        <?php endforeach ?>
                    </div><!-- .section-content -->

                    <?php if ( !empty( $options['popular_course_btn_title'] ) && !empty( $options['popular_course_btn_link'] ) ): ?>
                        <div class="read-more view-all">
                            <a href="<?php echo esc_url( $options['popular_course_btn_link'] ); ?>" class="btn">
                                <?php echo esc_html( $options['popular_course_btn_title'] ); ?>
                            </a>
                        </div><!-- .read-more -->
                    <?php endif ?>
                    
                </div><!-- .wrapper -->
            </div><!-- #popular-courses -->
        </div>
        
    <?php }
endif;