<?php
/**
 * products_collection section
 *
 * This is the template for the content of products_collection section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_products_collection_section' ) ) :
    /**
    * Add products_collection section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_products_collection_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if products_collection is enabled on frontpage
        $products_collection_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'products_collection_section_enable' );

        if ( ( true !== $products_collection_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render products_collection section now.
        teach_kiddo_pro_render_products_collection_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_products_collection_section' ) ) :
  /**
   * Start products_collection section
   *
   * @return string products_collection content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_products_collection_section() {
        $options = teach_kiddo_pro_get_theme_options();

    ?>

    <div id="teach_kiddo_pro_products_collection_section">
        <div id="products-collection" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'products-collection' );
                endif; ?> 
                <div class="section-header">
                    <?php if ( !empty( $options['products_collection_title'] ) ): ?>
                        <h2 class="section-title">
                            <span><?php echo esc_html( $options['products_collection_title'] ); ?></span>                            
                            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                        </h2>
                    <?php endif; ?>     
                </div><!-- .section-header -->

                <div class="section-content grid col-2">
                    <?php for ( $i=1; $i <= 4; $i++ ) { 
                        if ( empty($options['products_collection_content_products_collection_category_'.$i]) ) {
                            continue;
                    }
                    $thumbnail_id = get_term_meta( $options['products_collection_content_products_collection_category_'.$i], 'thumbnail_id', true );
                    $image = !empty( wp_get_attachment_url( $thumbnail_id ) ) ? wp_get_attachment_url( $thumbnail_id ) : get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                    $cat_name = get_term_by( 'id', $options['products_collection_content_products_collection_category_'.$i], 'product_cat' )->name;
                    $cat_link = get_category_link( $options['products_collection_content_products_collection_category_'.$i] );
                    ?>
                    <article class="grid-item">
                        <div class="featured-image" style="background-image: url('<?php echo esc_url($image); ?>');">
                            <div class="entry-container">
                                <span class="cat-links">
                                    <ul class="post-categories">
                                        <li><?php echo esc_html( $cat_name ); ?></li>
                                    </ul>
                                </span><!-- .cat-links -->
                                <?php if ( !empty( $options['products_collection_sub_title_'.$i] ) ): ?>
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $cat_link ) ?>"><?php echo esc_html( $options['products_collection_sub_title_'.$i] ); ?></a></h2>
                                    </header>
                                <?php endif ?>
                                <?php if ( !empty( $options['products_collection_btn_label'] ) ): ?>
                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $cat_link ) ?>" class="btn">Start Shopping</a>
                                    </div><!-- .read-more -->
                                <?php endif ?>                                
                            </div><!-- .entry-container -->
                        </div><!-- .featured-image -->
                    </article>
                    <?php } ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #products-collction -->
    </div>

    <?php }
endif;