<?php
/**
 * Promotion section
 *
 * This is the template for the content of promotion section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_promotion_section' ) ) :
    /**
    * Add promotion section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_promotion_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if promotion is enabled on frontpage
        $promotion_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'promotion_section_enable' );

        if ( true !== $promotion_enable ) {
            return false;
        }
        // Get promotion section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_promotion_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render promotion section now.
        teach_kiddo_pro_render_promotion_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_promotion_section_details' ) ) :
    /**
    * promotion section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input promotion section details.
    */
    function teach_kiddo_pro_get_promotion_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $promotion_content_type  = $options['promotion_content_type'];
        
        $content = array();
        switch ( $promotion_content_type ) {

            case 'custom':
                $custom['title']        = ! empty( $options['promotion_title'] ) ? $options['promotion_title'] : '';
                $custom['excerpt']      = ! empty( $options['promotion_description'] ) ? $options['promotion_description'] : '';
                $custom['url']          = ! empty( $options['promotion_button_link'] ) ? $options['promotion_button_link'] : '';
                

                // Push to the main array.
                array_push( $content, $custom );
            break;
            
            case 'page':
                $page_id = ! empty( $options['promotion_content_page'] ) ? $options['promotion_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['promotion_content_post'] ) ? $options['promotion_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $promotion_content_type ) :

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['promotion_excerpt_length'] );
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

            endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// promotion section content details.
add_filter( 'teach_kiddo_pro_filter_promotion_section_details', 'teach_kiddo_pro_get_promotion_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_promotion_section' ) ) :
  /**
   * Start promotion section
   *
   * @return string promotion content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
function teach_kiddo_pro_render_promotion_section( $content_details = array() ) {
    $options = teach_kiddo_pro_get_theme_options();
    $promotion_image = ! empty( $options['promotion_image'] ) ? $options['promotion_image'] : '';

    if ( empty( $content_details ) ) {
        return;
    } 
    ?>
    
    <div id="teach_kiddo_pro_promotion_section">

        <?php foreach ( $content_details as $content ): ?>

            <div id="promotion-section" class="relative page-section" style="background-image: url('<?php echo esc_url( $promotion_image ); ?>');">
                <div class="overlay"></div>
                <div class="wrapper">
                    <?php 
                    if ( is_customize_preview()):
                        teach_kiddo_pro_section_tooltip( 'promotion-section' );
                    endif;

                    if( !empty( $content['title'] ) ): ?>
                    <header class="entry-header">
                        <h2 class="entry-title"><?php echo esc_html( $content['title'] ) ; ?></h2>
                    </header>
                <?php endif;

                if( !empty( $content['excerpt'] ) ): ?>
                <div class="entry-content">
                    <p><?php echo wp_kses_post( $content['excerpt'] ) ; ?></p>
                </div><!-- .entry-content -->
            <?php endif;

            if ( ! empty( $options['promotion_button'] ) && !empty( $content['url'] ) ): ?>

            <div class="read-more">
                <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="btn"><?php echo esc_html( $options['promotion_button'] ) ; ?></a>
            </div>

        <?php endif; ?>

    </div>
</div>

<?php endforeach; ?>

</div>


    <?php
}
endif;