<?php
/**
 * Blog Posts section
 *
 * This is the template for the content of recent_posts section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_recent_posts_section' ) ) :
    /**
    * Add recent_posts section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_recent_posts_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if recent_posts is enabled on frontpage
        $recent_posts_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'recent_posts_section_enable' );

        if ( true !== $recent_posts_enable ) {
            return false;
        }
        // Get recent_posts section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_recent_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render recent_posts section now.
        teach_kiddo_pro_render_recent_posts_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_recent_posts_section_details' ) ) :
    /**
    * recent_posts section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input recent_posts section details.
    */
    function teach_kiddo_pro_get_recent_posts_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $recent_posts_content_type  = $options['recent_posts_content_type'];
        $recent_posts_count = !empty( $options['recent_posts_count'] ) ? $options['recent_posts_count'] : 3;
        $content = array();
        switch ( $recent_posts_content_type ) {
            
            case 'page':
                $page_ids = array();
                $author = array();

                for ( $i = 1; $i <= $recent_posts_count; $i++ ) {
                    if ( ! empty( $options['recent_posts_content_page_' . $i] ) ) :
                        $page_ids[] = $options['recent_posts_content_page_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $recent_posts_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $author = array();

                for ( $i = 1; $i <= $recent_posts_count; $i++ ) {
                    if ( ! empty( $options['recent_posts_content_post_' . $i] ) ) :
                        $post_ids[] = $options['recent_posts_content_post_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $recent_posts_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['recent_posts_content_category'] ) ? $options['recent_posts_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $recent_posts_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;
            
            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['recent_posts_excerpt_length'] );
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
   
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// recent_posts section content details.
add_filter( 'teach_kiddo_pro_filter_recent_posts_section_details', 'teach_kiddo_pro_get_recent_posts_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_recent_posts_section' ) ) :
  /**
   * Start recent_posts section
   *
   * @return string recent_posts content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_recent_posts_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        $section_title = !empty( $options['recent_posts_title'] ) ? $options['recent_posts_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_recent_posts_section">
            <div id="recent-posts-section" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'recent-posts-section' );
                    endif; ?>
                     <?php if ( $options['recent_posts_title'] ): ?>
                        <div class="section-header">
                            <h2 class="section-title">
                                <span><?php echo esc_html( $options['recent_posts_title'] ) ; ?></span>
                                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                            </h2>
                         </div><!-- .section-header -->
                    <?php endif; ?>   


                    <div class="section-content col-3 clear">
                        <?php foreach ( $content_details as $content ) : ?>
                            <article>
                                <div class="post-wrapper">
                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="blog"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <?php the_category( '', '', $content['id'] ); ?>
                                            </span>
                                        </div><!-- .entry-meta -->

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                        </div><!-- .entry-content -->

                                        <div class="post-footer-meta">
                                            <?php echo teach_kiddo_pro_author( get_the_author_meta( $content['id'] ) );teach_kiddo_pro_posted_on( $content['id'] ); ?>
                                        </div><!-- .entry-meta -->
                                    </div><!-- .entry-container -->
                                </div><!-- .post-wrapper -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #recent-posts-section -->
        </div>     

    <?php }
endif;