<?php
/**
 * Service section
 *
 * This is the template for the content of service section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_service_section' ) ) :
    /**
    * Add service section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_service_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if service is enabled on frontpage
        $service_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'service_section_enable' );

        if ( true !== $service_enable ) {
            return false;
        }
        // Get service section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }


        teach_kiddo_pro_render_service_section( $section_details );

    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_service_section_details' ) ) :
    /**
    * service section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input service section details.
    */
    function teach_kiddo_pro_get_service_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $service_content_type  = $options['service_content_type'];
        $service_count = ! empty( $options['service_count'] ) ? $options['service_count'] : 3;
        
        $content = array();
        switch ( $service_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $service_count; $i++ ) {
                    if ( ! empty( $options['service_content_page_' . $i] ) )
                        $page_ids[] = $options['service_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $service_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $service_count; $i++ ) {
                    if ( ! empty( $options['service_content_post_' . $i] ) )
                        $post_ids[] = $options['service_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $service_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['service_content_category'] ) ? $options['service_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $service_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['service_excerpt_length'] );
                    $page_post['url']       = get_the_permalink();
                    
                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// service section content details.
add_filter( 'teach_kiddo_pro_filter_service_section_details', 'teach_kiddo_pro_get_service_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string service content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_service_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_service_section">
            <div id="service-section" class="relative page-section">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-1.png' ?>" class="layer layer-1" alt="layer-1">
                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-2.png' ?>" class="layer layer-2" alt="layer-2">
                <div class="wrapper">
                <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'service-section' );
                endif; ?>    
                    
                    <?php if ( $options['service_title'] || $options['service_sub_title']): ?>
                        <div class="section-header">
                            <h2 class="section-title">
                                <span><?php echo esc_html( $options['service_title'] ) ; ?></span>
                                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                            </h2>
                            <p class="section-subtitle"><?php echo esc_html( $options['service_sub_title'] ) ; ?></p>
                         </div><!-- .section-header -->
                    <?php endif; ?>   

                    <div class="section-content  col-2">
                        <?php  $i=1; foreach ( $content_details as $content ): ?>        
                            <article>
                                <div class="service-item">
                                    <div class="entry-container">
                                        <?php if ( !empty( $options['service_content_icon_'.$i] ) ): ?>
                                            <div class="icon-container">
                                                <a href="<?php echo esc_url( $content['url'] ) ; ?>"><i class="fa <?php echo esc_attr( $options['service_content_icon_'.$i] ) ?>"></i></a>
                                            </div><!-- .icon-container -->
                                        <?php endif ?>                                        

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo esc_html( $content['excerpt'] ) ; ?></p>
                                        </div><!-- .entry-content -->
                                    </div><!-- .entry-container -->
                                </div><!-- .service-item -->
                            </article>
                        <?php $i++; endforeach ?>
                    </div><!-- .services-items-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- #services -->
        </div>       
    <?php }
endif;