<?php
/**
 * Slider section
 *
 * This is the template for the content of slider section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_slider_section' ) ) :
    /**
    * Add slider section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_slider_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if slider is enabled on frontpage
        $slider_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'slider_section_enable' );

        if ( true !== $slider_enable ) {
            return false;
        }
        // Get slider section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_slider_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        teach_kiddo_pro_render_slider_section( $section_details );
    

    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_slider_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input slider section details.
    */
    function teach_kiddo_pro_get_slider_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $slider_content_type  = $options['slider_content_type'];
        $slider_count = ! empty( $options['slider_count'] ) ? $options['slider_count'] : 3;
        
        $content = array();
        switch ( $slider_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $slider_count; $i++ ) {
                    if ( ! empty( $options['slider_content_page_' . $i] ) )
                        $page_ids[] = $options['slider_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $slider_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $slider_count; $i++ ) {
                    if ( ! empty( $options['slider_content_post_' . $i] ) )
                        $post_ids[] = $options['slider_content_post_' . $i];
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $slider_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['slider_content_category'] ) ? $options['slider_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $slider_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['slider_excerpt_length'] );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// slider section content details.
add_filter( 'teach_kiddo_pro_filter_slider_section_details', 'teach_kiddo_pro_get_slider_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_slider_section' ) ) :
  /**
   * Start slider section
   *
   * @return string slider content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_slider_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();
        $slider_autoplay = ($options['slider_autoplay']) ? 'true' : 'false';
        $btn_label = ! empty( $options['slider_btn_label'] ) ? $options['slider_btn_label'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_slider_section">

         <div id="featured-slider-section" class="slider-section">
        
            <div class="featured-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 800, "dots": true, "arrows": false, "autoplay": <?php echo( esc_attr( $slider_autoplay ) ) ; ?>, "draggable": true, "fade": false }'>
                <?php $i=1; foreach ( $content_details as $content ): ?>
                    <article style="background-image: url('<?php echo esc_url( $content['image'] ) ; ?>');">    
                        <div class="overlay"></div>
                        <div class="wrapper">
                            <?php if ( is_customize_preview()):
                                teach_kiddo_pro_section_tooltip( 'featured-slider-section' );
                            endif; ?>
                            <div class="featured-content-wrapper">
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ) ; ?></p>
                                    </div><!-- .entry-content -->
                                    <?php if ( $options['slider_search_enable'] ){
                                        if ( $options['slider_course_search_enable'] ) {
                                            teach_kiddo_pro_course_searchform(); 
                                        }else{
                                            get_search_form();
                                        }
                                       
                                    } ?>                                    
                                </div><!-- .entry-container -->
                                <?php if ( !empty( $options['slider_read_more'] ) || !empty( $options['slider_btn_title'] ) ): ?>
                                     <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="btn" tabindex="0"><?php echo esc_html( $options['slider_read_more'] ) ; ?></a>
                                        <?php if ( !empty( $options['slider_btn_link'] ) ): ?>
                                            <a href="<?php echo esc_url( $options['slider_btn_link'] ) ; ?>" class="btn" tabindex="0"><?php echo esc_html( $options['slider_btn_title'] ) ; ?></a>
                                        <?php endif ?>
                                        
                                    </div>
                                <?php endif ?>
                               
                            </div><!-- .featured-content-wrapper -->
                        </div><!-- .wrapper -->
                    </article>
                <?php $i++; endforeach ?>       
            </div><!-- .featured-slider -->
        </div><!-- #featured-slider-section -->

        </div>

    <?php }
endif;