<?php
/**
 * Latest Posts section
 *
 * This is the template for the content of stories section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_stories_section' ) ) :
    /**
    * Add stories section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_stories_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if stories is enabled on frontpage
        $stories_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'stories_section_enable' );

        if ( true !== $stories_enable ) {
            return false;
        }
        // Get stories section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_stories_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render stories section now.
        teach_kiddo_pro_render_stories_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_stories_section_details' ) ) :
    /**
    * stories section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input stories section details.
    */
    function teach_kiddo_pro_get_stories_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $stories_content_type  = $options['stories_content_type'];
        $stories_count = !empty( $options['stories_count'] ) ? $options['stories_count'] : 3;
        $content = array();
        switch ( $stories_content_type ) {
            
            case 'page':
                $page_ids = array();
                $author = array();

                for ( $i = 1; $i <= $stories_count; $i++ ) {
                    if ( ! empty( $options['stories_content_page_' . $i] ) ) :
                        $page_ids[] = $options['stories_content_page_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $stories_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $author = array();

                for ( $i = 1; $i <= $stories_count; $i++ ) {
                    if ( ! empty( $options['stories_content_post_' . $i] ) ) :
                        $post_ids[] = $options['stories_content_post_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $stories_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['stories_content_category'] ) ? $options['stories_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $stories_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;
            
            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['stories_excerpt_length'] );
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
   
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// stories section content details.
add_filter( 'teach_kiddo_pro_filter_stories_section_details', 'teach_kiddo_pro_get_stories_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_stories_section' ) ) :
  /**
   * Start stories section
   *
   * @return string stories content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_stories_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();

        $section_sub_title = !empty( $options['stories_sub_title'] ) ? $options['stories_sub_title'] : '';
        $section_title = !empty( $options['stories_title'] ) ? $options['stories_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_stories_section">
            <div id="stories-section" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        teach_kiddo_pro_section_tooltip( 'stories-section' );
                    endif; ?> 
                    <?php if ( $options['stories_title'] ): ?>
                        <div class="section-header">
                            <h2 class="section-title">
                                <span><?php echo esc_html( $options['stories_title'] ) ; ?></span>
                                <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                            </h2>
                        </div><!-- .section-header -->
                    <?php endif; ?>   

                    <div class="section-content col-1 clear">
                        <?php foreach ( $content_details as $content ) : ?>
                        <article>
                            <div class="post-wrapper">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                </div><!-- .featured-image -->
                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php foreach ( get_the_category($content['id']) as $cat): ?>
                                                <ul class="post-categories">
                                                    <li><a href="<?php echo esc_url( get_category_link( $cat->term_id ) ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
                                                </ul>                     
                                            <?php endforeach ?>                              
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div>

                                    <div class="post-footer-meta">
                                        <?php echo teach_kiddo_pro_author( get_the_author_meta( $content['id'] ) );teach_kiddo_pro_posted_on( $content['id'] ); ?>
                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </div><!-- .post-wrapper -->
                        </article>
                        <?php endforeach; ?>
                    </div><!-- .section-content -->

                    <?php if ( !empty( $options['stories_btn_label'] ) && !empty( $options['stories_btn_link'] )  ): ?>
                        <div class="read-more">
                            <a href="<?php echo esc_url( $options['stories_btn_link'] ); ?>" class="btn"><?php echo esc_html( $options['stories_btn_label'] ); ?></a>
                        </div><!-- .read-more -->
                    <?php endif ?>                    
                </div><!-- .wrapper -->
            </div><!-- #stories-section -->
        </div>
       
    <?php }
endif;