<?php
/**
 * Subscription section
 *
 * This is the template for the content of subscription section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_subscription_section' ) ) :
    /**
    * Add subscription section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_subscription_section() {
        $options = teach_kiddo_pro_get_theme_options();

        // Check if subscription is enabled on frontpage
        $subscription_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'subscription_section_enable' );
        
        if ( true !== $subscription_enable ) {
           return false;
        }

        // Render subscription section now.
        teach_kiddo_pro_render_subscription_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_subscription_section' ) ) :
  /**
   * Start subscription section
   *
   * @return string subscription content
   * @since Teach Kiddo Pro 1.0.0
   *    
   */
function teach_kiddo_pro_render_subscription_section() {
    if ( ! class_exists( 'Jetpack' ) ) {
       return;
    } elseif ( class_exists( 'Jetpack' ) ) {
        if ( ! Jetpack::is_module_active( 'subscriptions' ) )
           return;
    }
    $options = teach_kiddo_pro_get_theme_options();

    $subscription_title             = ! empty( $options['subscription_title'] ) ? $options['subscription_title'] : '';
    $subscription_description       = ! empty( $options['subscription_description'] ) ? $options['subscription_description'] : '';
    $subscription_btn_title         = ! empty( $options['subscription_btn_title'] ) ? $options['subscription_btn_title'] : esc_html__( 'Subscribe Now', 'teach-kiddo-pro' );
    $subscription_image          = ! empty( $options['subscription_image'] ) ? $options['subscription_image'] : '';

 ?>

 <div id="teach_kiddo_pro_subscription_section">
    <div id="subscribe-us" class="relative page-section">
        <div class="wrapper">
            <div class="section-header">
                <?php if ( !empty( $subscription_image ) ): ?>
                    <img src="<?php echo esc_url($subscription_image); ?>" alt="06">
                <?php endif ?>
                
                <?php if( !empty( $subscription_title ) ):
                    ?>
                    <h2 class="section-title"><?php echo esc_html($subscription_title); ?></h2>
                <?php endif;
                if( !empty( $subscription_description ) ): ?>                            
                    <p><?php echo esc_html($subscription_description); ?></p>                            
                <?php endif; ?>
            </div><!-- .section-header -->

            <div class="subscribe-form-wrapper">
                <?php 
                    $subscription_shortcode = '[jetpack_subscription_form title="" subscribe_text="" subscribe_button="' . esc_html( $subscription_btn_title ) . '" show_subscribers_total="0"]';
                    echo do_shortcode( wp_kses_post( $subscription_shortcode ) ); 
                ?> 
            </div><!-- .subscribe-form-wrapper -->
        </div><!-- .wrapper -->
    </div><!-- #subscribe-now -->
</div>
    
<?php }
endif;