    <?php
/**
 * team section
 *
 * This is the template for the content of team section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_team_section' ) ) :
    /**
    * Add team section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_team_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if team is enabled on frontpage
        $team_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'team_section_enable' );

        if ( true !== $team_enable ) {
            return false;
        }
        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render team section now.
        teach_kiddo_pro_render_team_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_team_section_details' ) ) :
    /**
    * team section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input team section details.
    */
    function teach_kiddo_pro_get_team_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $team_content_type  = $options['team_content_type'];
        $team_count = ! empty( $options['team_count'] ) ? $options['team_count'] : 5;
        
        $content = array();
        switch ( $team_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_page_' . $i] ) ) :
                        $page_ids[] = $options['team_content_page_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_post_' . $i] ) ) :
                        $post_ids[] = $options['team_content_post_' . $i];
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['team_content_category'] ) ? $options['team_content_category'] : '';

                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $team_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'tp-team':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $team_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_team_' . $i] ) ) :
                        $team_ids[] = $options['team_content_team_' . $i];
                    endif;
                }

               $args = array(
                    'post_type'         => 'tp-team',
                    'post__in'          => ( array ) $team_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    ); 

            break;

            case 'tp-team-category':
                 if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }

                $cat_id = ! empty( $options['team_content_team_category'] ) ? $options['team_content_team_category'] : '';

                $args = array(
                    'post_type'         => 'tp-team',
                    'posts_per_page'    => absint( $team_count ),
                    'tax_query'         => array(  
                        array( 
                            'taxonomy'  => 'tp-team-category', 
                            'field'     => 'id', 
                            'terms'     => array( $cat_id ),  
                            ) 
                        ),
                    );  
            break;

            default:
            break;
        }

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                $i = 1;
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                     $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
                    $page_post['social']    = (! empty( $options['team_social_' . $i] ) ) ? $options['team_social_' . $i] : '';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// team section content details.
add_filter( 'teach_kiddo_pro_filter_team_section_details', 'teach_kiddo_pro_get_team_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_team_section' ) ) :
  /**
   * Start team section
   *
   * @return string team content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
function teach_kiddo_pro_render_team_section( $content_details = array() ) {
    $options = teach_kiddo_pro_get_theme_options();
    $team_content_type  = $options['team_content_type'];
  
    if ( empty( $content_details ) ) {
        return;
} ?>

<div id="teach_kiddo_pro_team_section">

    <div id="team-section" class="relative page-section">
        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-3.png' ?>" class="layer layer-3" alt="layer-3">
        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-4.png' ?>" class="layer layer-4" alt="layer-4">
        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-5.png' ?>" class="layer layer-5" alt="layer-5">
        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-6.png' ?>" class="layer layer-6" alt="layer-6">
        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-7.png' ?>" class="layer layer-7" alt="layer-7">
        <div class="wrapper">
            <?php if ( is_customize_preview()):
            teach_kiddo_pro_section_tooltip( 'team-section' );
            endif; ?>
            <div class="section-header">
                <?php if ( $options['team_title'] ): ?>
                    <h2 class="section-title">
                        <span><?php echo esc_html( $options['team_title'] ) ; ?></span>
                        <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                    </h2>
                <?php endif; ?>
            </div><!-- .section-header -->

            <div class="section-content col-4 clear">
                <?php $i=1; foreach ( $content_details as $content ): ?>
                <article>
                    <div class="team-item-wrapper">
                        <div class="featured-image">
                            <a href="<?php echo esc_url( $content['url'] ) ; ?>" alt="<?php echo esc_attr( $content['title'] ) ; ?>"><img src="<?php echo esc_url( $content['image'] ) ?>" alt="<?php echo esc_attr( $content['title'] ) ; ?>"></a>
                        </div><!-- .featured-image -->

                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>" alt="<?php echo esc_attr( $content['title'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                <?php if ( in_array($team_content_type, array('tp-team', 'tp-team-category') ) ): ?>
                                    <span class="team-position"><?php echo esc_html( get_post_meta( $content['id'], 'tp_team_designation_value', true ) ); ?></span>
                                    <?php else: ?>
                                         <span class="team-position"><?php echo esc_html( $options['team_position_'.$i] ); ?></span>
                                <?php endif; ?>                           
                            </header>

                            <?php if ( in_array($team_content_type, array('tp-team', 'tp-team-category') ) ):
                            teach_kiddo_pro_team_social( $content['id'] );
                            endif ; ?>

                            <?php if ( in_array($team_content_type, array('page', 'post', 'category') ) ):
                            if ( ! empty( $content['social'] ) ) {
                                $social = explode( '|', $content['social'] ); ?>
                                <div class="social-icons">
                                    <ul>
                                        <?php foreach( $social as $social_link ) : ?>
                                            <li>
                                                <a href="<?php echo esc_url( $social_link ); ?>">
                                                    <?php echo teach_kiddo_pro_return_social_icon( $social_link ); ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            <?php } endif; ?>
                        </div><!-- .entry-container -->
                    </div><!-- team-item-wrapper -->
                </article>
                <?php $i++; endforeach ?>
            </div><!-- .col-3 -->
            <?php if ( !empty( $options['team_btn_title'] ) && !empty( $options['team_btn_url'] ) ): ?>
                <div class="read-more view-all">
                    <a href="<?php echo esc_url( $options['team_btn_url'] ); ?>" class="btn">
                        <?php echo esc_html( $options['team_btn_title'] ); ?>
                    </a>
                </div><!-- .read-more -->
            <?php endif ?>
        </div><!-- .wrapper -->
    </div><!-- #team-section -->

</div>
  
    <?php }
endif;