<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_testimonial_section() {
        $options = teach_kiddo_pro_get_theme_options();
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'teach_kiddo_pro_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        teach_kiddo_pro_render_testimonial_section( $section_details );
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Teach Kiddo Pro 1.0.0
    * @param array $input testimonial section details.
    */
    function teach_kiddo_pro_get_testimonial_section_details( $input ) {
        $options = teach_kiddo_pro_get_theme_options();

        // Content type.
        $testimonial_content_type  = $options['testimonial_content_type'];
        $testimonial_count = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 3;

        $content = array();
        switch ( $testimonial_content_type ) {
            
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                        $page_ids[] = $options['testimonial_content_page_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_post_' . $i] ) ) :
                        $post_ids[] = $options['testimonial_content_post_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['testimonial_content_category'] ) ? $options['testimonial_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $testimonial_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'testimonial':
                if ( ! class_exists( 'TP_Education' ) ) {
                    return;
                }
                $testimonial_ids = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_testimonial_' . $i] ) ) :
                        $testimonial_ids[] = $options['testimonial_content_testimonial_' . $i];
                    endif;
                }

               $args = array(
                    'post_type'         => 'tp-testimonial',
                    'post__in'          => ( array ) $testimonial_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        $i = 0;
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['position']  = !empty( $position[$i] ) ? $position[$i] : '';
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = teach_kiddo_pro_trim_content( $options['testimonial_excerpt_length'] );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
                $i++;
            endwhile;
        endif;
        wp_reset_postdata();
        
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// testimonial section content details.
add_filter( 'teach_kiddo_pro_filter_testimonial_section_details', 'teach_kiddo_pro_get_testimonial_section_details' );


if ( ! function_exists( 'teach_kiddo_pro_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_testimonial_section( $content_details = array() ) {
        $options = teach_kiddo_pro_get_theme_options();
        $testimonial_autoplay = (bool) ($options['testimonial_section_autoplay_slider_enable']) ? 'true' : 'false';
        $testimonial_button_slider = (bool) ($options['testimonial_section_buttom_slider_enable']) ? 'true' : 'false';
        $testimonial_content_type  = $options['testimonial_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="teach_kiddo_pro_testimonial_section">

        <div id="testimonial-section" class="relative page-section same-background">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-15.png' ?>" class="layer layer-15" alt="layer-15">
            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-16.png' ?>" class="layer layer-16" alt="layer-16">
            <div class="wrapper">
            <?php if ( is_customize_preview()):
                teach_kiddo_pro_section_tooltip( 'testimonial-section' );
                endif; ?>
                <div class="section-header">
                    <?php if ( !empty( $options['testimonial_title'] ) ): ?>
                        <h2 class="section-title">
                            <span><?php echo esc_html( $options['testimonial_title'] ); ?></span>                            
                            <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/section-title-layer.png' ?>" alt="section-title-layer">
                        </h2>
                    <?php endif; ?>                
                </div><!-- .section-header -->

                <div class="testimonial-slider">
                     <img src="<?php echo esc_url( get_template_directory_uri() ). '/assets/images/layer-17.png' ?>" class="layer layer-17" alt="layer-17">
                     <div class="slider-for">
                        <?php foreach ( $content_details as $content ): ?>
                            <article>
                                <div class="entry-content">
                                    <p>‘‘ <?php echo esc_html( $content['excerpt'] ) ; ?> ’’</p>
                                </div><!-- .entry-content -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .slider-for-->
                    <div class="slider-nav">
                    <?php $i = 1; foreach ( $content_details as $content ): ?>
                        <article>
                            <div class="entry-container">
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>" attr="<?php echo esc_attr( $content['title'] ) ; ?>">
                                </div><!-- .featured-image -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><?php echo esc_html( $content['title'] ) ; ?></h2>
                                    <?php if( $testimonial_content_type !== 'testimonial' ){ ?>
                                        <?php if( !empty( $options['testimonial_position_'.$i] ) ): ?>
                                            <span class="testimonial-position"><?php echo esc_html( $options['testimonial_position_'.$i] ) ?></span>
                                        <?php endif; ?>
                                        <?php }else{ ?>
                                    <?php teach_kiddo_pro_testimonial_designation( $content['id'] ); } ?>
                                </header>
                            </div><!-- .entry-container -->
                        </article>
                    <?php $i++; endforeach ?>
                    </div>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #testimonial-section -->

        </div>
        
    <?php }
endif;