<?php
/**
 * trending_products section
 *
 * This is the template for the content of trending_products section
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
if ( ! function_exists( 'teach_kiddo_pro_add_trending_products_section' ) ) :
    /**
    * Add trending_products section
    *
    *@since Teach Kiddo Pro 1.0.0
    */
    function teach_kiddo_pro_add_trending_products_section() {
    	$options = teach_kiddo_pro_get_theme_options();
        // Check if trending_products is enabled on frontpage
        $trending_products_enable = apply_filters( 'teach_kiddo_pro_section_status', true, 'trending_products_section_enable' );

        if ( ( true !== $trending_products_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render trending_products section now.
        teach_kiddo_pro_render_trending_products_section();
    }
endif;

if ( ! function_exists( 'teach_kiddo_pro_render_trending_products_section' ) ) :
  /**
   * Start trending_products section
   *
   * @return string trending_products content
   * @since Teach Kiddo Pro 1.0.0
   *
   */
   function teach_kiddo_pro_render_trending_products_section() {
        $options = teach_kiddo_pro_get_theme_options();

    ?>

    <div id="teach_kiddo_pro_trending_products_section">
       <div id="trending-products" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    teach_kiddo_pro_section_tooltip( 'trending-products' );
                endif; ?>
                <div class="section-content clear">
                    <?php for ( $i=1; $i <=3 ; $i++) { 
                        $cat_id = ! empty( $options['trending_products_content_category_'.$i] ) ? $options['trending_products_content_category_'.$i] : '';
                    ?>
                        <div class="product-wrapper">
                            <?php if ( !empty( $options['trending_products_label_'.$i] ) ): ?>
                                <h2 class="category-title">
                                    <?php echo esc_html( $options['trending_products_label_'.$i] ); ; ?>
                                </h2> 
                            <?php endif ?>                                    
                            
                            <div class="product-items">
                                <?php 
                                    $args = array(
                                    'post_type'         => 'product',
                                    'posts_per_page'    => 3,
                                    'tax_query'         => array(
                                        array(
                                            'taxonomy'  => 'product_cat',
                                            'field'     => 'id',
                                            'terms'     => $cat_id
                                        )
                                    ) );
                                    $query = new WP_Query( $args );
                                    if ( $query->have_posts() ) : 
                                        while ( $query->have_posts() ) : $query->the_post();
                                    ?>
                                        <article>
                                            <div class="featured-image">
                                                <a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url();?>"></a>
                                            </div><!-- .featured-image -->

                                            <div class="entry-container">
                                                <span class="cat-links">
                                                    <ul class="post-categories">
                                                         <?php 
                                                            $terms = get_the_terms ( get_the_id(), 'product_cat' );
                                                            foreach ( $terms as $term ) { ?>
                                                                <li class="posted_in">
                                                                    <a href="<?php echo esc_url( get_term_link( $term->term_id, 'product_cat' ) ) ?>"><?php echo esc_html( $term->name) ; ?></a>
                                                                </li><!-- .posted_in -->
                                                               
                                                        <?php } ?>
                                                    </ul>
                                                </span><!-- .cat-links -->

                                                <header class="entry-header">
                                                    <h2 class="entry-title">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h2>
                                                </header>

                                                <span class="price">
                                                   <?php 
                                                        $product = new WC_Product( get_the_id() );
                                                        echo $product->get_price_html();
                                                    ?>
                                                </span><!-- .price -->
                                            </div><!-- .entry-container -->
                                        </article>
                                    <?php
                                        endwhile;
                                    endif;
                                    wp_reset_postdata();
                                ?>  
                                   
                            </div><!-- .product-items -->
                        </div><!-- .product-wrapper -->
                    <?php } ?>                    
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- .trending-products -->
    </div>

    <?php }
endif;