<?php
/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

$options = teach_kiddo_pro_get_theme_options();


if ( ! function_exists( 'teach_kiddo_pro_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 */
	function teach_kiddo_pro_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>>
	<?php
	}
endif;

add_action( 'teach_kiddo_pro_doctype', 'teach_kiddo_pro_doctype', 10 );


if ( ! function_exists( 'teach_kiddo_pro_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif;
	}
endif;
add_action( 'teach_kiddo_pro_before_wp_head', 'teach_kiddo_pro_head', 10 );

if ( ! function_exists( 'teach_kiddo_pro_page_start' ) ) :
	/**
	 * Page starts html codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_page_start() {
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'teach-kiddo-pro' ); ?></a>
			<div class="menu-overlay"></div>

		<?php
	}
endif;
add_action( 'teach_kiddo_pro_page_start_action', 'teach_kiddo_pro_page_start', 10 );

if ( ! function_exists( 'teach_kiddo_pro_page_end' ) ) :
	/**
	 * Page end html codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_page_end() {
		?>
		</div><!-- #page -->
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_page_end_action', 'teach_kiddo_pro_page_end', 10 );



if ( ! function_exists( 'teach_kiddo_pro_header_start' ) ) :
	/**
	 * Header start html codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_header_start() { 
		$options  = teach_kiddo_pro_get_theme_options();
	?>	
		<?php if ( $options['topbar_section_enable'] == true ): ?>
			<div id="top-navigation" class="relative">
	            <div class="wrapper">
	                <div class="col-2">	             
                        <div class="contact-info">
                            <li>
                            	<a href="tel:<?php echo esc_attr( $options['topbar_field_1'] ) ; ?>">          
                            		<?php echo teach_kiddo_pro_get_svg( array( 'icon' => 'phone' ) ) ; ?>
	                                <?php
	                                	echo esc_html( $options['topbar_field_1'] ) ;
	                                ?>
                               </a>
                            </li>
                            <li>
                            	<a href="mailto:<?php echo esc_attr( $options['topbar_field_2'] ) ; ?>">                                	         
	                                <?php echo teach_kiddo_pro_get_svg( array( 'icon' => 'message' ) ) ; ?>
	                                <?php
	                                	echo esc_html( $options['topbar_field_2'] ) ;
	                                ?>
                               </a>
                            </li>
                        </div><!-- .contact-info -->

                        <div class="secondary-menu">
                        	<?php if ( $options['social_menu_enable'] == true && has_nav_menu('social')):   

			            		wp_nav_menu( array(
			            			'theme_location' => 'social',
			            			'container' => false,
			            			'menu_class' => 'social-icons',
			            			'echo' => true,
			            			'fallback_cb' => false,
			            			'depth' => 1,
			            			'link_before' => '<span class="screen-reader-text">',
									'link_after' => '</span>',
			            		 ) );
			            	endif; ?>                            
                        </div><!-- .secondary-menu -->	            
	                </div><!-- .col-2 -->
	            </div><!-- .wrapper -->
	        </div><!-- #top-bar -->
        <?php endif; ?>
		<header id="masthead" class="site-header" role="banner">
			<div class="wrapper">
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_header_action', 'teach_kiddo_pro_header_start', 20 );

if ( ! function_exists( 'teach_kiddo_pro_site_branding' ) ) :
	/**
	 * Site branding codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_site_branding() {
		$options  = teach_kiddo_pro_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];		
		?>		
		<div class="site-branding">
			<?php if ( in_array( $header_txt_logo_extra, array( 'show-all', 'logo-title', 'logo-tagline' ) )  ) { ?>
				<div class="site-logo">
					<?php the_custom_logo(); ?>
				</div>
			<?php } 
			if ( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline' ) ) ) : ?>
				<div id="site-details">
					<?php
					if( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title' ) )  ) {
						if ( teach_kiddo_pro_is_latest_posts() || teach_kiddo_pro_is_frontpage() ) : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php
						endif;
					} 
					if ( in_array( $header_txt_logo_extra, array( 'show-all', 'tagline-only', 'logo-tagline' ) ) ) {
						$description = get_bloginfo( 'description', 'display' );
						if ( $description || is_customize_preview() ) : ?>
							<p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
						<?php
						endif; 
					}?>
				</div>
	    	<?php endif; ?>
		</div><!-- .site-branding -->
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_header_action', 'teach_kiddo_pro_site_branding', 20 );

if ( ! function_exists( 'teach_kiddo_pro_site_navigation' ) ) :
	/**
	 * Site navigation codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_site_navigation() {
		$options = teach_kiddo_pro_get_theme_options();
		?>
		<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
				<span class="menu-label"><?php esc_html_e( 'Menu', 'teach-kiddo-pro' ); ?></span>			
				<?php
				echo teach_kiddo_pro_get_svg( array( 'icon' => 'menu' ) );
				echo teach_kiddo_pro_get_svg( array( 'icon' => 'close' ) );
				?>		
			</button>
				<?php 
					$menu_btn = '';
					if ( !empty( $options['menu_btn_title'] ) ) :
						$menu_btn = '<li>';
						$menu_btn .= '<a href="'.$options['menu_btn_url'].'" class="custom-button">';
						$menu_btn .= esc_html( $options['menu_btn_title'] );
		                $menu_btn .= '</a></li>';
	                endif;
	        	
	        		wp_nav_menu(array(
	        			'theme_location' => 'primary',
	        			'container' => 'div',
	        			'menu_class' => 'menu nav-menu',
	        			'menu_id' => 'primary-menu',
	        			'echo' => true,
	        			'fallback_cb' => 'teach_kiddo_pro_menu_fallback_cb',
	        			'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s' . $menu_btn . '</ul>',
	        		));
	        	?>
        	</div><!-- .wrapper -->
		</nav><!-- #site-navigation -->
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_header_action', 'teach_kiddo_pro_site_navigation', 30 );


if ( ! function_exists( 'teach_kiddo_pro_header_end' ) ) :
	/**
	 * Header end html codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_header_end() {
		?>
		</header><!-- #masthead -->
		<?php
	}
endif;

add_action( 'teach_kiddo_pro_header_action', 'teach_kiddo_pro_header_end', 50 );

if ( ! function_exists( 'teach_kiddo_pro_content_start' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_content_start() {
		?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_content_start_action', 'teach_kiddo_pro_content_start', 10 );

if ( ! function_exists( 'teach_kiddo_pro_header_image' ) ) :
	/**
	 * Header Image codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_header_image() {
		if ( teach_kiddo_pro_is_frontpage() )
			return;
		$header_image = get_header_image();
		$options = teach_kiddo_pro_get_theme_options();
		if ( is_single() && $options['hide_single_post_banner']	): ?>
			<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	            <div class="overlay"></div>
	            <div class="wrapper">
	                <header class="page-header">
	                    <h2 class="page-title"><?php echo teach_kiddo_pro_custom_header_banner_title(); ?></h2>
	                </header>

	                <?php teach_kiddo_pro_add_breadcrumb(); ?>
	            </div><!-- .wrapper -->
	        </div><!-- #page-site-header -->
		<?php endif;
		if ( is_single() && !$options['hide_single_post_banner']	): ?>
			<div class="wrapper">
				<?php teach_kiddo_pro_add_breadcrumb(); ?>
			</div>
		<?php endif;
		if ( is_page() && $options['hide_single_page_banner']	): ?>
			<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	            <div class="overlay"></div>
	            <div class="wrapper">
	                <header class="page-header">
	                    <h2 class="page-title"><?php echo teach_kiddo_pro_custom_header_banner_title(); ?></h2>
	                </header>

	                <?php teach_kiddo_pro_add_breadcrumb(); ?>
	            </div><!-- .wrapper -->
	        </div><!-- #page-site-header -->
		<?php endif;
		if ( is_page() && !$options['hide_single_post_banner']	): ?>
			<div class="wrapper">
				<?php teach_kiddo_pro_add_breadcrumb(); ?>
			</div>
		<?php endif;
		if ( is_archive()): ?>
			<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	            <div class="overlay"></div>
	            <div class="wrapper">
	                <header class="page-header">
	                    <?php teach_kiddo_pro_custom_header_banner_title(); ?>
	                </header>

	                <?php teach_kiddo_pro_add_breadcrumb(); ?>
	            </div><!-- .wrapper -->
	        </div><!-- #page-site-header -->
		<?php endif;
		
	}
endif;
add_action( 'teach_kiddo_pro_header_image_action', 'teach_kiddo_pro_header_image', 10 );

if ( ! function_exists( 'teach_kiddo_pro_add_breadcrumb' ) ) :
	/**
	 * Add breadcrumb.
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 */
	function teach_kiddo_pro_add_breadcrumb() {
		$options = teach_kiddo_pro_get_theme_options();
		// Bail if Breadcrumb disabled.
		$breadcrumb = $options['breadcrumb_enable'];
		if ( false === $breadcrumb ) {
			return;
		}
		
		// Bail if Home Page.
		if ( teach_kiddo_pro_is_frontpage() ) {
			return;
		}

		echo '<div id="breadcrumb-list">';
				/**
				 * teach_kiddo_pro_simple_breadcrumb hook
				 *
				 * @hooked teach_kiddo_pro_simple_breadcrumb -  10
				 *
				 */
				do_action( 'teach_kiddo_pro_simple_breadcrumb' );
		echo '</div><!-- #breadcrumb-list -->';
		return;
	}
endif;

if ( ! function_exists( 'teach_kiddo_pro_content_end' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_content_end() {
		?>
			
		</div><!-- #content -->
		<?php
	}
endif;
add_action( 'teach_kiddo_pro_content_end_action', 'teach_kiddo_pro_content_end', 10 );

if ( ! function_exists( 'teach_kiddo_pro_footer_start' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_footer_start() {
		$options = teach_kiddo_pro_get_theme_options();
		$footer_bg = isset( $options['footer_image'] ) ? $options['footer_image'] : "";
	?>
		<footer id="colophon" class="site-footer" role="contentinfo" style="background-image: url('<?php echo esc_url( $footer_bg ) ?>');">

		<?php
	}
endif;
add_action( 'teach_kiddo_pro_footer', 'teach_kiddo_pro_footer_start', 10 );

if ( ! function_exists( 'teach_kiddo_pro_footer_site_info' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_footer_site_info() {
		$options = teach_kiddo_pro_get_theme_options();
		$search = array( '[the-year]', '[site-link]' );

        $replace = array( date( 'Y' ), '<a href="'. esc_url( home_url( '/' ) ) .'">'. esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a>' );

        $options['copyright_text'] = str_replace( $search, $replace, $options['copyright_text'] );

		$copyright_text = $options['copyright_text']; 
		?>
		
		<div class="site-info">
			<div class="wrapper">
				<?php if( !empty( $copyright_text ) ):?>
				<span class="copyright">
					<?php echo teach_kiddo_pro_santize_allow_tag( $copyright_text ); ?>
				</span>
			<?php endif; ?>
		</div><!-- .wrapper -->    
	</div><!-- .site-info -->

		<?php
	}
endif;
add_action( 'teach_kiddo_pro_footer', 'teach_kiddo_pro_footer_site_info', 40 );


if ( ! function_exists( 'teach_kiddo_pro_footer_end' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_footer_end() {
		$options = teach_kiddo_pro_get_theme_options();
		?>
		</footer>
		<?php if ( true === $options['scroll_top_visible'] ) : ?>
			<div class="backtotop"><?php echo teach_kiddo_pro_get_svg( array( 'icon' => 'up' ) ); ?></div>
		<?php endif;
	}
endif;
add_action( 'teach_kiddo_pro_footer', 'teach_kiddo_pro_footer_end', 100 );

if ( ! function_exists( 'teach_kiddo_pro_loader' ) ) :
	/**
	 * Start div id #loader
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_loader() {
		$options = teach_kiddo_pro_get_theme_options();
		if ( $options['loader_enable'] ) { ?>

			<div id="loader">
            <div class="loader-container">
            	<?php if ( 'default' == $options['loader_icon'] ) : ?>
	                <div id="preloader">
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                    <span></span>
	                </div>
	            <?php else :
	            	echo teach_kiddo_pro_get_svg( array( 'icon' => esc_attr( $options['loader_icon'] ) ) );
	            endif; ?>
            </div>
        </div><!-- #loader -->
        <div class="menu-overlay"></div>
		<?php }
	}
endif;
add_action( 'teach_kiddo_pro_before_header', 'teach_kiddo_pro_loader', 10 );

if ( ! function_exists( 'teach_kiddo_pro_infinite_loader_spinner' ) ) :
	/**
	 *
	 * @since Teach Kiddo Pro 1.0.0
	 *
	 */
	function teach_kiddo_pro_infinite_loader_spinner() { 
		$id = get_the_ID();
		$options = teach_kiddo_pro_get_theme_options();
		if ( $options['pagination_type'] == 'infinite' ) :
			if ( ! empty( $id ) ) {
				echo '<div class="blog-loader">' . teach_kiddo_pro_get_svg( array( 'icon' => 'spinner-umbrella' ) ) . '</div>';
			}
		endif;
	}
endif;
add_action( 'teach_kiddo_pro_infinite_loader_spinner_action', 'teach_kiddo_pro_infinite_loader_spinner', 10 );
