<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */

$options = teach_kiddo_pro_get_theme_options();
$class = has_post_thumbnail() ? '' : 'no-post-thumbnail';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'clear ' . $class ); ?>>
    <div class="post-wrapper">
    	<?php if ( teach_kiddo_pro_is_frontpage() ) : ?>
			<header class="entry-header">
				<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
			</header><!-- .entry-header -->
		<?php endif; ?>
		<?php if ( !$options['hide_single_page_banner'] ): ?>
			<header class="entry-header">
		        <h2 class="entry-title"><?php the_title(); ?></h2>
		    </header>
		<?php endif ?>
		
		<?php if( $options['single_post_hide_image'] == false ):
		if (has_post_thumbnail()): ?>
			<div class="featured-image">
				<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url( 'large' ) ?>" alt="<?php the_title(); ?>"></a>
			</div>
		<?php endif;
		endif; ?>
    	<div class="entry-container">
			<div class="entry-content">
				<?php
					the_content();

					wp_link_pages( array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'teach-kiddo-pro' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->

			<?php if ( get_edit_post_link() ) : ?>
				<footer class="entry-footer">
					<?php
						edit_post_link(
							sprintf(
								/* translators: %s: Name of current post */
								esc_html__( 'Edit %s', 'teach-kiddo-pro' ),
								the_title( '<span class="screen-reader-text">"', '"</span>', false )
							),
							'<span class="edit-link">',
							'</span>'
						);
					?>
				</footer><!-- .entry-footer -->
			<?php endif; ?>
		</div><!-- .entry-container -->
	</div><!-- .post-wrapper -->
</article><!-- #post-## -->
