<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
$options = teach_kiddo_pro_get_theme_options();
$class = has_post_thumbnail() ? '' : 'no-post-thumbnail';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'clear ' . $class ); ?>>
	
	<div class="entry-container">
		<?php if ( !$options['hide_single_post_banner'] ): ?>
			<header class="entry-header">
		        <h2 class="entry-title"><?php the_title(); ?></h2>
		    </header>
		<?php endif ?>
		<?php if( $options['single_post_hide_image'] == false ):
		if (has_post_thumbnail()): ?>
			<div class="featured-image">
				<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url( 'large' ) ?>" alt="<?php the_title(); ?>"></a>
			</div>
		<?php endif;
		endif; ?>
		<?php if( $options['single_post_hide_description'] == false ): ?>	
		<div class="entry-content">
			<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'teach-kiddo-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'teach-kiddo-pro' ),
				'after'  => '</div>',
				) );
				?>
			</div><!-- .entry-content -->		
		<?php endif; ?>
	</div><!-- .entry-container -->

	<div class="entry-meta">
		<?php if ( ! $options['single_post_hide_author'] ) :
		echo teach_kiddo_pro_author( get_the_author_meta( 'ID' ) );
		endif; 

		if ( ! $options['single_post_hide_date'] ) :
			teach_kiddo_pro_posted_on(); 
		endif; ?>

		<?php  
		teach_kiddo_pro_single_categories();
		teach_kiddo_pro_entry_footer();
		?>

	</div><!-- .entry-meta -->

</article><!-- #post-## -->