<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Teach Kiddo Pro
 * @since Teach Kiddo Pro 1.0.0
 */
$class = has_post_thumbnail() ? 'has-post-thumbnail' : '';
$options = teach_kiddo_pro_get_theme_options();
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
    <div class="post-item">

        <?php if( $options['hide_image'] == false ):

        if( has_post_thumbnail() ){ ?>
        <div class="featured-image" style="background-image: url('<?php the_post_thumbnail_url( 'large' ); ?>');">
            <a href="<?php the_permalink(); ?>" class="post-thumbnail-link"></a>
        </div>
        <?php } 

        endif; ?>

        <div class="entry-container">
            <div class="entry-meta">
                <?php if ( $options['hide_category'] == false ): ?>
                    <span class="cat-links">
                        <?php the_category(); ?>
                    </span>
                <?php endif; ?>
                <?php  if ( $options['hide_date'] == false ): ?>
                    <?php teach_kiddo_pro_posted_on() ; ?>
                <?php endif; ?>
            </div>

            <?php if( $options['hide_title'] == false ): ?>
                <header class="entry-header">
                    <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                </header>
            <?php endif; ?>
            <?php if ( !empty( $options['archive_btn_title'] ) ): ?>
                <div class="read-more">
                    <a href="<?php the_permalink(); ?>" class="btn"><?php echo esc_html( $options['archive_btn_title'] ); ?></a>
                </div><!-- .read-more -->
            <?php endif ?>
            
        </div><!-- .entry-container -->
    </div><!-- .post-wrapper -->
</article>