<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Corpopress Pro
	 * @since Corpopress Pro 1.0.0
	 */

	/**
	 * corpopress_pro_doctype hook
	 *
	 * @hooked corpopress_pro_doctype -  10
	 *
	 */
	do_action( 'corpopress_pro_doctype' );

?>
<head>
<?php
	/**
	 * corpopress_pro_before_wp_head hook
	 *
	 * @hooked corpopress_pro_head -  10
	 *
	 */
	do_action( 'corpopress_pro_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * corpopress_pro_page_start_action hook
	 *
	 * @hooked corpopress_pro_page_start -  10
	 *
	 */
	do_action( 'corpopress_pro_page_start_action' ); 

	/**
	 * corpopress_pro_loader_action hook
	 *
	 * @hooked corpopress_pro_loader -  10
	 *
	 */
	do_action( 'corpopress_pro_before_header' );

	/**
	 * corpopress_pro_header_action hook
	 *
	 * @hooked corpopress_pro_header_start -  10
	 * @hooked corpopress_pro_site_branding -  20
	 * @hooked corpopress_pro_site_navigation -  30
	 * @hooked corpopress_pro_header_end -  50
	 *
	 */
	do_action( 'corpopress_pro_header_action' );

	/**
	 * corpopress_pro_content_start_action hook
	 *
	 * @hooked corpopress_pro_content_start -  10
	 *
	 */
	do_action( 'corpopress_pro_content_start_action' );

	/**
	 * corpopress_pro_header_image_action hook
	 *
	 * @hooked corpopress_pro_header_image -  10
	 *
	 */
	do_action( 'corpopress_pro_header_image_action' );

   if ( corpopress_pro_is_frontpage() ) {
    	$options = corpopress_pro_get_theme_options();
    	$sorted = array();
		$sorted = explode( ',' , corpopress_pro_get_homepage_sections() );
		
		foreach ( $sorted as $section ) {
			add_action( 'corpopress_pro_primary_content', 'corpopress_pro_add_'. $section .'_section' );
		}

		do_action( 'corpopress_pro_primary_content' );
	}